/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.telemetry.ph.impl;

import com.vmware.ph.client.api.impl.PhClientBuilder;
import com.vmware.ph.client.common.audit.AuditFilePayloadPersister;
import com.vmware.ph.common.audit.AuditFileConfig;
import com.vmware.ph.common.audit.PayloadAuditPersister;
import com.vmware.vsphere.client.telemetry.util.StorageUtil;
import org.apache.commons.io.FilenameUtils;

public class PhPlatformAuditStrategy {
    private static final String AUDIT_TARGET_FILENAME = "vsphere-web-client-ceip.audit";
    private static final int AUDIT_FILE_SIZE_BYTES = 0xA00000;
    private static final int AUDIT_FILE_MAX_HISTORY = 5;

    public void setAuditFileConfig(PhClientBuilder phClientBuilder) {
        AuditFileConfig auditFileConfig = this.getAuditFileConfig();
        phClientBuilder.setPayloadAuditPersister((PayloadAuditPersister)new AuditFilePayloadPersister(auditFileConfig));
    }

    private AuditFileConfig getAuditFileConfig() {
        String string = this.getAuditFilePath();
        AuditFileConfig auditFileConfig = new AuditFileConfig(string, true, 0xA00000, 5);
        return auditFileConfig;
    }

    private String getAuditFilePath() {
        String string = StorageUtil.getAuditDirectory();
        return FilenameUtils.concat((String)string, (String)AUDIT_TARGET_FILENAME);
    }
}

