/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.telemetry.ph.impl.payloads;

import com.vmware.ph.client.api.commondataformat.Payload;
import com.vmware.ph.client.api.commondataformat.PayloadBuilder;
import com.vmware.ph.client.api.commondataformat.types.FreeFormData;
import com.vmware.ph.client.api.commondataformat.types.Resource;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.AnyPrimitive;
import com.vmware.ph.client.api.commondataformat.types.nontoplevel.RelatedResource;
import com.vmware.vsphere.client.telemetry.ph.TelemetryPayloadBuilder;
import com.vmware.vsphere.client.telemetry.ph.model.CommonPayloadProperties;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class GenericPayloadBuilder
extends TelemetryPayloadBuilder {
    private static final String TYPE_GENERIC = "generic";
    private static final String RELATION_SUFFIX = ".relation";
    private static final String METADATA_PREFIX = "meta.";
    private static final String PROPERTY_RELATION_PREFIX = "relation-";
    private String dataType;

    @Override
    public String getType() {
        return TYPE_GENERIC;
    }

    @Override
    public Payload contructPayload(Map<String, Object> map) {
        CommonPayloadProperties commonPayloadProperties = GenericPayloadBuilder.constructCommonProperties(map);
        HashMap hashMap = (HashMap)map.get("data");
        if (hashMap == null) {
            throw new IllegalArgumentException("Data object is missing");
        }
        this.dataType = "" + map.get("type");
        if (this.dataType.length() == 0) {
            throw new IllegalArgumentException("Cannot log telemetry data, no data type provided");
        }
        String string = commonPayloadProperties.getIdFreeForm();
        FreeFormData freeFormData = new FreeFormData("ngc.meta." + this.dataType, string, new AnyPrimitive[]{new AnyPrimitive(commonPayloadProperties.getTimestamp()), new AnyPrimitive(commonPayloadProperties.getUserId()), new AnyPrimitive(commonPayloadProperties.getSessionId())});
        String string2 = UUID.randomUUID().toString();
        LinkedList<FreeFormData> linkedList = new LinkedList<FreeFormData>();
        LinkedList<RelatedResource> linkedList2 = new LinkedList<RelatedResource>();
        List<AnyPrimitive> list = this.processDynamicObject(hashMap, linkedList, linkedList2);
        FreeFormData freeFormData2 = new FreeFormData("ngc." + this.dataType, string2, list.toArray(new AnyPrimitive[list.size()]));
        linkedList2.add(new RelatedResource("ngc.meta." + this.dataType, string));
        linkedList2.add(new RelatedResource("ngc." + this.dataType, string2));
        String string3 = String.valueOf(Math.random());
        Resource resource = new Resource("ngc." + this.dataType + RELATION_SUFFIX, string3, null, linkedList2.toArray(new RelatedResource[linkedList2.size()]));
        PayloadBuilder payloadBuilder = new PayloadBuilder();
        payloadBuilder.add(new FreeFormData[]{freeFormData, freeFormData2});
        payloadBuilder.add(new Resource[]{resource});
        for (FreeFormData freeFormData3 : linkedList) {
            payloadBuilder.add(new FreeFormData[]{freeFormData3});
        }
        Payload payload = payloadBuilder.build();
        return payload;
    }

    private List<AnyPrimitive> processDynamicObject(Map<String, Object> map, List<FreeFormData> list, List<RelatedResource> list2) {
        LinkedList<AnyPrimitive> linkedList = new LinkedList<AnyPrimitive>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            linkedList.add(this.processProperty(PROPERTY_RELATION_PREFIX + entry.getKey(), entry.getValue(), list, list2));
        }
        return linkedList;
    }

    private List<AnyPrimitive> processObjectArray(Object[] objectArray, List<FreeFormData> list, List<RelatedResource> list2) {
        LinkedList<AnyPrimitive> linkedList = new LinkedList<AnyPrimitive>();
        for (Object object : objectArray) {
            linkedList.add(this.processProperty(null, object, list, list2));
        }
        return linkedList;
    }

    private AnyPrimitive processProperty(String string, Object object, List<FreeFormData> list, List<RelatedResource> list2) {
        AnyPrimitive anyPrimitive;
        List<AnyPrimitive> list3 = null;
        String string2 = UUID.randomUUID().toString();
        if (object instanceof Map) {
            list3 = this.processDynamicObject((Map)object, list, list2);
        } else if (object instanceof Object[]) {
            list3 = this.processObjectArray((Object[])object, list, list2);
        }
        if (list3 != null && string != null) {
            FreeFormData freeFormData = new FreeFormData("ngc." + this.dataType, string2, list3.toArray(new AnyPrimitive[list3.size()]));
            list2.add(new RelatedResource(string, string2));
            list.add(freeFormData);
            anyPrimitive = new AnyPrimitive(string);
        } else {
            anyPrimitive = new AnyPrimitive("" + object);
        }
        return anyPrimitive;
    }
}

