/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.telemetry.util;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageUtil {
    private static final String STORAGE_DIRECTORY_PROPERTY = "PS_BASEDIR";
    private static final String TEMP_DIRECTORY_PROPERTY = "java.io.tmpdir";
    private static final String CEIP_DIRECTORY = "ceip";
    private static final String AUDIT_DIRECTORY = "audit";
    private static final String BUFFERING_DIRECTORY = "buffering";
    private static final String UI_DIRECTORY = "ui";
    private static final Log _logger = LogFactory.getLog(StorageUtil.class);

    private static String getStorageDirectory() {
        String string = System.getProperty(STORAGE_DIRECTORY_PROPERTY);
        if (string == null) {
            string = System.getProperty(TEMP_DIRECTORY_PROPERTY);
            _logger.warn((Object)("Could not find storage directory. Will default to " + string));
        }
        return string;
    }

    private static String getCeipSubDirectory() {
        File file = new File(StorageUtil.getStorageDirectory(), CEIP_DIRECTORY);
        return file.getPath();
    }

    public static String getAuditDirectory() {
        File file = new File(StorageUtil.getCeipSubDirectory(), AUDIT_DIRECTORY);
        File file2 = new File(file, UI_DIRECTORY);
        return file2.getPath();
    }

    public static String getBufferingDirectory() {
        File file = new File(StorageUtil.getCeipSubDirectory(), BUFFERING_DIRECTORY);
        File file2 = new File(file, UI_DIRECTORY);
        return file2.getPath();
    }
}

