/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.vim.CustomFieldsManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.I18nUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.PeerVcConnectionError;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.HttpHostConnectException;

public class MixedUtil {
    public static String CLIENT_NAME = I18nUtil.getLocalizedString("client.productName", new String[0]);
    public static String IPV6_SCOPE_ID_SEPARATOR = "%";
    public static final String ATTR_NAME_INVOCATION_START = "#invocation.start#";
    public static final String ATTR_NAME_INVOCATION_END = "#invocation.end#";
    private static Log _logger = LogFactory.getLog(MixedUtil.class);

    public static MethodFault getMethodFault(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof MethodFault) {
            return (MethodFault)throwable;
        }
        throwable = MixedUtil.getVimException(throwable);
        MethodFault methodFault = new MethodFault();
        methodFault.setMessage(throwable.getMessage());
        methodFault.initCause(throwable);
        if (throwable instanceof RuntimeFault) {
            methodFault.setFaultCause((Exception)((RuntimeFault)throwable));
        }
        return methodFault;
    }

    public static Exception getVimException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof InvocationTargetException && (throwable = throwable.getCause()) instanceof MethodFault) {
            return (MethodFault)throwable;
        }
        Exception exception = MixedUtil.newVcConnectionError(throwable);
        if (exception != null) {
            throwable = exception;
        }
        if (throwable.getCause() instanceof NotAuthenticatedError) {
            throwable = throwable.getCause();
        }
        if (throwable != null && !(throwable instanceof Exception)) {
            _logger.warn((Object)"Not an instance of Exception. Will wrap in Exception.", throwable);
            throwable = new Exception(throwable.getMessage(), throwable);
        }
        return (Exception)throwable;
    }

    public static MethodFault getInvalidEntityFault() {
        String string = I18nUtil.getLocalizedString("error.invalidEntityArgument", new String[0]);
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
        MethodFault methodFault = MixedUtil.getMethodFault(illegalArgumentException);
        return methodFault;
    }

    public static RuntimeFault getRuntimeFault(Exception exception) {
        RuntimeFault runtimeFault = new RuntimeFault();
        runtimeFault.setMessage(exception.getMessage());
        runtimeFault.initCause((Throwable)exception);
        runtimeFault.setFaultCause(exception);
        return runtimeFault;
    }

    public static RuntimeFault getRuntimeFault(String string) {
        RuntimeFault runtimeFault = new RuntimeFault();
        runtimeFault.setMessage(string);
        return runtimeFault;
    }

    public static CompositeException constructCompositeException(List<Exception> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<MethodFault> arrayList = new ArrayList<MethodFault>();
        for (Exception exception : list) {
            arrayList.add(MixedUtil.getMethodFault(exception));
        }
        return new CompositeException(arrayList);
    }

    public static CompositeException addToCompositeException(Exception exception, List<Exception> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (exception instanceof CompositeException) {
            for (Exception exception2 : ((CompositeException)exception).getExceptions()) {
                arrayList.add(exception2);
            }
        } else if (exception != null) {
            arrayList.add(exception);
        }
        for (Exception exception3 : list) {
            arrayList.add(MixedUtil.getMethodFault(exception3));
        }
        return new CompositeException(arrayList);
    }

    public static void throwIfSessionNotAuthenticated() {
        SamlToken samlToken = AuthSessionUtil.getSsoToken((SsoDomain)SsoDomain.getLocal());
        if (samlToken != null) {
            return;
        }
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup[] linkedVcGroupArray = null;
        if (linkedVcGroupRegistry != null) {
            linkedVcGroupArray = linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups();
        }
        if (linkedVcGroupArray == null || linkedVcGroupArray.length == 0) {
            _logger.warn((Object)("Session not authenticated: " + SessionUtil.getHashedSessionId()));
            throw new NotAuthenticatedError();
        }
    }

    public static void throwNotAuthenticatedError(Throwable throwable) {
        NotAuthenticatedError notAuthenticatedError = MixedUtil.newNotAuthenticatedError(throwable);
        throw notAuthenticatedError;
    }

    public static NotAuthenticatedError newNotAuthenticatedError(Throwable throwable) {
        NotAuthenticatedError notAuthenticatedError = throwable != null ? new NotAuthenticatedError(throwable) : new NotAuthenticatedError();
        _logger.error((Object)MixedUtil.getStackTrace((Throwable)notAuthenticatedError));
        return notAuthenticatedError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        PrintStream printStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            printStream.flush();
            String string = byteArrayOutputStream.toString();
            return string;
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                if (printStream != null) {
                    printStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static CustomFieldsManager getCustomFieldManager(ManagedObjectReference managedObjectReference) {
        CustomFieldsManager customFieldsManager = null;
        String string = managedObjectReference == null ? null : managedObjectReference.getServerGuid();
        VcService vcService = VimSessionUtil.getService(string);
        if (vcService == null) {
            return null;
        }
        try {
            ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
            if (serviceInstanceContent != null && serviceInstanceContent.customFieldsManager != null) {
                customFieldsManager = (CustomFieldsManager)ManagedObjectUtil.getManagedObject(serviceInstanceContent.customFieldsManager);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when try to get the custom fields manager object", (Throwable)exception);
        }
        return customFieldsManager;
    }

    public static String escapeVimEntityNameSpecialChars(String string) {
        if (string == null) {
            return string;
        }
        string = string.replaceAll("%", "%25");
        string = string.replaceAll("/", "%2f");
        string = string.replaceAll("\\\\", "%5c");
        return string;
    }

    public static String unescapeVimEntityNameSpecialChars(String string) {
        if (string == null) {
            return string;
        }
        string = string.replaceAll("%2f", "/");
        string = string.replaceAll("%2F", "/");
        string = string.replaceAll("%5c", "\\\\");
        string = string.replaceAll("%5C", "\\\\");
        string = string.replaceAll("%25", "%");
        return string;
    }

    public static boolean isLocalhost(String string) {
        return string.equals("127.0.0.1") || string.equals("0:0:0:0:0:0:0:1") || string.equals("::1") || string.equals("localhost");
    }

    public static String resolveIpForHost(String string) {
        String string2 = "";
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            string2 = inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            _logger.info((Object)("Host IP not resolvable by name. " + exception.getMessage()));
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                string2 = inetAddress.getHostAddress();
            }
            catch (Exception exception2) {
                _logger.info((Object)("Localhost IP not resolvable. " + exception2.getMessage()));
                string2 = "";
            }
        }
        if (MixedUtil.isLocalhost(string2)) {
            _logger.info((Object)"Loopback address detected for localhost");
            string2 = "";
        }
        return string2;
    }

    public static List<String> getAllLocalIPAddresses() throws SocketException {
        return MixedUtil.getAllLocalIPAddresses(false);
    }

    public static List<String> getAllLocalIPAddresses(boolean bl) throws SocketException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                int n;
                InetAddress inetAddress = enumeration2.nextElement();
                String string = inetAddress.getHostAddress();
                arrayList.add(string);
                if (!bl || !(inetAddress instanceof Inet6Address) || (n = string.indexOf(IPV6_SCOPE_ID_SEPARATOR)) == -1) continue;
                String string2 = string.substring(0, n);
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private static Exception newVcConnectionError(Throwable throwable) {
        if (!(throwable instanceof SocketException || throwable instanceof HttpHostConnectException || throwable.getCause() != null && (throwable.getCause() instanceof SocketException || throwable.getCause() instanceof HttpHostConnectException))) {
            return null;
        }
        HttpSession httpSession = SessionUtil.getHttpSession();
        if (httpSession == null) {
            _logger.debug((Object)"No session; cannot determine if this is a VC connection error", throwable);
            return null;
        }
        String string = throwable.getMessage();
        if (StringUtil.isNullOrWhitespace((String)string)) {
            _logger.warn((Object)"The exception contains no error message, therefore we can't extract the service URL", throwable);
            return null;
        }
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (linkedVcGroupRegistry == null) {
            return new NotAuthenticatedError(throwable);
        }
        LinkedVcGroup[] linkedVcGroupArray = linkedVcGroupRegistry.getLinkedVcGroups();
        if (linkedVcGroupArray == null || linkedVcGroupArray.length == 0) {
            return null;
        }
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray) {
            Collection<VcService> collection = linkedVcGroup.getVcServices();
            for (VcService vcService : collection) {
                String string2 = VcServiceUtil.getServiceUrl(vcService);
                if (!string.contains(string2)) continue;
                return new PeerVcConnectionError(string2, throwable);
            }
        }
        return null;
    }
}

