/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vcservice;

import com.google.common.base.Preconditions;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.I18nUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class VcServiceCompatibilityResult {
    protected final VcService _vcService;

    private VcServiceCompatibilityResult(@Nonnull VcService vcService) {
        Preconditions.checkArgument((vcService != null ? 1 : 0) != 0, (Object)"vcService is null");
        this._vcService = vcService;
    }

    public static VcServiceCompatibilityResult createCompatibleResult(@Nonnull VcService vcService) {
        return new Compatible(vcService);
    }

    public static VcServiceCompatibilityResult createIncompatibleResult(@Nonnull VcService vcService, @Nonnull VcServiceCompatibilityFailure vcServiceCompatibilityFailure, @Nullable String string) {
        Preconditions.checkArgument((vcServiceCompatibilityFailure != null ? 1 : 0) != 0, (Object)"compatibilityFailure is null");
        return new Incompatible(vcService, vcServiceCompatibilityFailure, string);
    }

    @Nonnull
    public VcService getVcService() {
        return this._vcService;
    }

    public abstract boolean isCompatible();

    @Nullable
    public abstract VcServiceCompatibilityFailure getFailure();

    @Nullable
    public abstract String getLocalizedErrorMessage();

    private static class Incompatible
    extends VcServiceCompatibilityResult {
        private final String _vSphereClientVersion;
        private final VcServiceCompatibilityFailure _compatibilityFailure;

        public Incompatible(@Nonnull VcService vcService, @Nonnull VcServiceCompatibilityFailure vcServiceCompatibilityFailure, @Nullable String string) {
            super(vcService);
            Preconditions.checkArgument((vcServiceCompatibilityFailure != null ? 1 : 0) != 0, (Object)"compatibilityFailure is null");
            this._compatibilityFailure = vcServiceCompatibilityFailure;
            this._vSphereClientVersion = string;
        }

        @Override
        public boolean isCompatible() {
            return false;
        }

        @Override
        @Nullable
        public VcServiceCompatibilityFailure getFailure() {
            return this._compatibilityFailure;
        }

        @Override
        @Nullable
        public String getLocalizedErrorMessage() {
            String string = this._compatibilityFailure.getLocalizedErrorMessage(this._vcService, this._vSphereClientVersion);
            return string;
        }
    }

    private static class Compatible
    extends VcServiceCompatibilityResult {
        public Compatible(@Nonnull VcService vcService) {
            super(vcService);
        }

        @Override
        public boolean isCompatible() {
            return true;
        }

        @Override
        @Nullable
        public VcServiceCompatibilityFailure getFailure() {
            return null;
        }

        @Override
        @Nullable
        public String getLocalizedErrorMessage() {
            return null;
        }
    }

    public static enum VcServiceCompatibilityFailure {
        SUPPORTED_VERSIONS_MISSING{

            @Override
            public String getLocalizedErrorMessage(@Nonnull VcService vcService, @Nullable String string) {
                String string2 = I18nUtil.getLocalizedString("vcService.supportedVersionsMissing", new String[0]);
                return string2;
            }
        }
        ,
        ESX_HOSTS_ARE_NOT_SUPPORTED{

            @Override
            public String getLocalizedErrorMessage(@Nonnull VcService vcService, @Nullable String string) {
                String string2 = I18nUtil.getLocalizedString("vcService.esxHostsAreNotSupported", new String[0]);
                string2 = String.format(string2, MixedUtil.CLIENT_NAME, VcServiceCompatibilityFailure.sanitizeClientVersion(string), VcServiceCompatibilityFailure.getHostName(vcService.getServiceUrl()));
                return string2;
            }
        }
        ,
        VERSION_NOT_AVAILABLE{

            @Override
            public String getLocalizedErrorMessage(@Nonnull VcService vcService, @Nullable String string) {
                String string2 = I18nUtil.getLocalizedString("vcService.vcVersionNotAvailable", new String[0]);
                string2 = String.format(string2, VcServiceCompatibilityFailure.getHostName(vcService.getServiceUrl()));
                return string2;
            }
        }
        ,
        UNSUPPORTED_VERSION{

            @Override
            public String getLocalizedErrorMessage(@Nonnull VcService vcService, @Nullable String string) {
                String string2 = I18nUtil.getLocalizedString("vcService.vcVersionUnsupported", new String[0]);
                string2 = String.format(string2, VcServiceCompatibilityFailure.getHostName(vcService.getServiceUrl()), vcService.getServiceVersion());
                return string2;
            }
        };


        public abstract String getLocalizedErrorMessage(@Nonnull VcService var1, @Nullable String var2);

        private static String sanitizeClientVersion(@Nullable String string) {
            if (StringUtil.isNullOrWhitespace((String)string)) {
                return "";
            }
            return string;
        }

        private static String getHostName(String string) {
            try {
                return URI.create(string).getHost();
            }
            catch (Exception exception) {
                return string;
            }
        }
    }
}

