/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vmomi.vc;

import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import com.vmware.vise.vim.commons.vmomi.vc.VcAwareHttpConfigurationProvider;
import java.security.KeyStore;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public final class VcAwareSharedHttpConfigPool
extends SharedHttpConfigPool
implements VcAwareHttpConfigurationProvider {
    private static final Log _logger = LogFactory.getLog(VcAwareSharedHttpConfigPool.class);

    public VcAwareSharedHttpConfigPool(@Nonnegative int n, @Nonnegative int n2) {
        super(n, n2);
    }

    public VcAwareSharedHttpConfigPool(@Nullable KeystoreService keystoreService, @Nonnegative int n, @Nonnegative int n2) {
        super(keystoreService, n, n2);
    }

    public VcAwareSharedHttpConfigPool(@Nullable KeystoreService keystoreService, @Nonnegative int n, @Nonnegative int n2, int n3) {
        super(keystoreService, n, n2, n3);
    }

    private VcAwareSharedHttpConfigPool(@Nullable KeystoreService keystoreService, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4, int n5, @Nonnull String string, @Nullable String[] stringArray) {
        super(keystoreService, n, n2, n3, n4, n5, string, stringArray);
    }

    @Override
    public HttpConfiguration getHttpConfig(@Nonnull ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        Validate.notNull((Object)serviceEndpoint, (String)"serviceEndpoint is null");
        String string = VcAwareSharedHttpConfigPool.getVcGuid(serviceEndpoint);
        return this.getHttpConfig(serviceEndpoint.getUrl(), null, null, string, serviceEndpoint.getCertificate(), serviceEndpoint.getSslThumbprint());
    }

    @Override
    public HttpConfiguration getHttpConfig(@Nonnull String string, @Nullable String string2, @Nullable KeyStore keyStore, @Nullable String string3) {
        Validate.isTrue((!StringUtil.isNullOrWhitespace((String)string) ? 1 : 0) != 0, (String)"identifier is empty");
        return this.getHttpConfig(string, keyStore, null, string2, null, string3);
    }

    @Override
    public HttpConfiguration getHttpConfig(@Nonnull String string, @Nullable Class<?> clazz, @Nullable String string2, @Nullable String string3) {
        Validate.isTrue((!StringUtil.isNullOrWhitespace((String)string) ? 1 : 0) != 0, (String)"identifier is empty");
        VmodlVersion vmodlVersion = null;
        if (clazz != null) {
            VmodlVersionMap vmodlVersionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
            vmodlVersion = vmodlVersionMap.getVersion(clazz);
        }
        if (vmodlVersion == null) {
            _logger.warn((Object)("VMODL version class " + clazz.getCanonicalName() + " not found in the " + VmodlVersionMap.class.getSimpleName() + ". This will hinder the determination of the optimal features that should be applied for the HTTP configuration."));
        }
        return this.getHttpConfig(string, null, vmodlVersion, null, string2, string3);
    }

    private HttpConfiguration getHttpConfig(@Nonnull String string, @Nullable KeyStore keyStore, @Nullable VmodlVersion vmodlVersion, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        HttpConfiguration httpConfiguration = this.getPreexistingConfiguration(string);
        if (httpConfiguration != null) {
            return httpConfiguration;
        }
        HttpConfiguration httpConfiguration2 = this.createHttpConfigInternal(keyStore, vmodlVersion, string2, string3, string4);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Created a new HttpConfiguration for " + string + ": " + Integer.toHexString(System.identityHashCode(httpConfiguration2))));
        }
        SharedHttpConfigPool.SharedHttpConfig sharedHttpConfig = new SharedHttpConfigPool.SharedHttpConfig(httpConfiguration2);
        httpConfiguration = this.insertOrUpdateSharedHttpConfig(string, sharedHttpConfig);
        return httpConfiguration;
    }

    public HttpConfiguration updateThumbprint(ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        String string = VcAwareSharedHttpConfigPool.getVcGuid(serviceEndpoint);
        return this.updateThumbprint(null, null, string, serviceEndpoint.getUrl(), serviceEndpoint.getCertificate(), serviceEndpoint.getSslThumbprint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpConfiguration updateThumbprint(@Nullable KeyStore keyStore, @Nullable VmodlVersion vmodlVersion, @Nullable String string, @Nonnull String string2, @Nullable String string3, @Nullable String string4) {
        HttpConfiguration httpConfiguration = this.createHttpConfigInternal(keyStore, vmodlVersion, string, string3, string4);
        SharedHttpConfigPool.SharedHttpConfig sharedHttpConfig = new SharedHttpConfigPool.SharedHttpConfig(httpConfiguration);
        this._lock.writeLock().lock();
        try {
            SharedHttpConfigPool.SharedHttpConfig sharedHttpConfig2 = (SharedHttpConfigPool.SharedHttpConfig)this._httpConfigDataByUrl.get(string2);
            if (sharedHttpConfig2 != null) {
                sharedHttpConfig.setTheSameActiveSessionCountAs(sharedHttpConfig2);
            } else {
                sharedHttpConfig.incrementAndGetActiveSessionCount();
            }
            this._httpConfigDataByUrl.put(string2, sharedHttpConfig);
        }
        finally {
            this._lock.writeLock().unlock();
        }
        _logger.info((Object)("Created http config with updated thumbprint.  " + string2));
        return sharedHttpConfig.getHttpConfiguration();
    }

    @Override
    public void releaseHttpConfig(ServiceDirectory.ServiceEndpoint serviceEndpoint, boolean bl) {
        Validate.notNull((Object)serviceEndpoint, (String)"serviceEndpoint is null");
        String string = serviceEndpoint.getUrl();
        this.releaseHttpConfig(string, bl);
    }

    private static String getVcGuid(@Nonnull ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        assert (serviceEndpoint != null);
        String string = null;
        try {
            if (serviceEndpoint instanceof ServiceEndpointEx) {
                string = ((ServiceEndpointEx)serviceEndpoint).getVcGuid();
            } else {
                ServiceEndpointEx serviceEndpointEx = ServiceEndpointEx.toServiceEndpointEx(serviceEndpoint);
                string = serviceEndpointEx.getVcGuid();
            }
        }
        catch (Exception exception) {
            _logger.warn((Object)"Can't determine the vcGuid. Will treat it as null.", (Throwable)exception);
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("The VC guid is null or empty");
        }
        return string;
    }

    private HttpConfiguration createHttpConfigInternal(@Nullable KeyStore keyStore, @Nullable VmodlVersion vmodlVersion, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        if (keyStore == null) {
            boolean bl = false;
            if (vmodlVersion != null) {
                bl = VcServiceUtil.is60VcOrLater(vmodlVersion);
            } else if (string != null) {
                bl = VcServiceUtil.is60VcOrLater(string);
            }
            if (bl) {
                keyStore = this.getSystemKeyStore();
            }
        }
        HttpConfiguration httpConfiguration = this.createHttpConfig(keyStore, string2, string3);
        return httpConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends SharedHttpConfigPool.Builder {
        public VcAwareSharedHttpConfigPool build() {
            return new VcAwareSharedHttpConfigPool(this._keystoreService, this._maxConnections, this._maxConnectionsPerRoute, this._timeoutInMillis, this._connectionTimeoutInMillis, this._keepAlivePeriodMillis, this._userAgent, this._enabledProtocols);
        }

        public Builder sslConfigurationProvider(@Nullable SSLConfigurationProvider sSLConfigurationProvider) {
            return (Builder)super.sslConfigurationProvider(sSLConfigurationProvider);
        }

        public Builder keyStoreService(@Nullable KeystoreService keystoreService) {
            return (Builder)super.keyStoreService(keystoreService);
        }

        public Builder maxConnections(@Nonnegative int n) {
            return (Builder)super.maxConnections(n);
        }

        public Builder maxConnectionsPerRoute(@Nonnegative int n) {
            return (Builder)super.maxConnectionsPerRoute(n);
        }

        public Builder connectionTimeoutInMillis(@Nonnegative int n) {
            return (Builder)super.connectionTimeoutInMillis(n);
        }

        public Builder timeoutInMillis(@Nonnegative int n) {
            return (Builder)super.timeoutInMillis(n);
        }

        public Builder keepAlivePeriodMillis(@Nonnegative int n) {
            return (Builder)super.keepAlivePeriodMillis(n);
        }

        public Builder userAgent(@Nonnull String string) {
            return (Builder)super.userAgent(string);
        }

        public Builder enabledProtocols(@Nonnull String string) {
            return (Builder)super.enabledProtocols(string);
        }

        public Builder enabledProtocols(@Nonnull String[] stringArray) {
            return (Builder)super.enabledProtocols(stringArray);
        }
    }
}

