/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vsphere.internal;

import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.Timeout;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Config {
    private static final Log _logger = LogFactory.getLog(Config.class);
    private static final String CONFIG_FILE_NAME = "vim-commons-vsphere.properties";
    public static final int VMOMI_HTTP_CONNECTION_POOL_SIZE_VC;
    public static final int VMOMI_HTTP_SOCKET_TIMEOUT_VC;
    public static final int VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_VC;
    public static final long VMOMI_VC_INVOCATION_TIME_THRESHOLD_IN_MILLIS;
    public static final Timeout VMOMI_VC_CLIENT_PERMIT_RELEASE_TIMEOUT_MS;
    public static final long VC_VERSION_CACHE_EXPIRATION_IN_MILLIS;
    public static final long THREAD_POOL_WARN_QUEUE_WAIT_TIME_THRESHOLD_NANOS;
    public static final int THREAD_POOL_WARN_DIAGNOSTICS_DELAYED_TASK_STEP_SIZE;
    public static final int THREAD_POOL_WARN_DIAGNOSTICS_REJECTED_TASK_STEP_SIZE;
    public static final long THREAD_POOL_WARN_DIAGNOSTICS_MIN_TIME_APART_NANOS;

    static {
        ClassLoader classLoader = Config.class.getClassLoader();
        Properties properties = PropertyUtil.loadProperties((ClassLoader)classLoader, (String)CONFIG_FILE_NAME);
        if (properties == null) {
            _logger.warn((Object)"Properties file not found. Will use System properties or, if they are not specified or not valid, will use defaults.");
        }
        VMOMI_HTTP_CONNECTION_POOL_SIZE_VC = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.commons.vmomi.http.connection.pool.size.vc", (int)500);
        VMOMI_HTTP_SOCKET_TIMEOUT_VC = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.commons.vmomi.http.socket.timeout.vc", (int)120000);
        VMOMI_HTTP_SOCKET_CONNECTION_TIMEOUT_VC = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.commons.vmomi.http.socket.connection.timeout.vc", (int)10000);
        VMOMI_VC_INVOCATION_TIME_THRESHOLD_IN_MILLIS = PropertyUtil.getIntProperty((Properties)properties, (String)"vim.commons.vmomi.vc.invocation.time.threshold", (int)10000);
        long l = PropertyUtil.getLongProperty((Properties)properties, (String)"vim.commons.vmomi.vc.client.permit.release.timeout", (long)5000L);
        Timeout timeout = l <= 0L ? Timeout.INFINITE : Timeout.valueOf((long)l);
        VMOMI_VC_CLIENT_PERMIT_RELEASE_TIMEOUT_MS = timeout;
        VC_VERSION_CACHE_EXPIRATION_IN_MILLIS = PropertyUtil.getLongProperty((Properties)properties, (String)"vc.version.cache.expiration", (long)600000L);
        THREAD_POOL_WARN_QUEUE_WAIT_TIME_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(PropertyUtil.getLongProperty((Properties)properties, (String)"threadPool.warning.queueWaitTimeThreshold", (long)5000L));
        THREAD_POOL_WARN_DIAGNOSTICS_DELAYED_TASK_STEP_SIZE = PropertyUtil.getIntProperty((Properties)properties, (String)"threadPool.warning.diagnostics.delayedTaskStepSize", (int)20);
        THREAD_POOL_WARN_DIAGNOSTICS_REJECTED_TASK_STEP_SIZE = PropertyUtil.getIntProperty((Properties)properties, (String)"threadPool.warning.diagnostics.rejectedTaskStepSize", (int)20);
        THREAD_POOL_WARN_DIAGNOSTICS_MIN_TIME_APART_NANOS = TimeUnit.MILLISECONDS.toNanos(PropertyUtil.getLongProperty((Properties)properties, (String)"threadPool.warning.diagnostics.minTimeApart", (long)60000L));
    }
}

