/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data.h5.remediate.util;

import com.vmware.vsphere.client.hostprofile.data.RemediateHostConfigData;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.tree.RemediateNode;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.util.PrecheckRemediateHelper;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.util.RemediateItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RemediateItemBuilder {
    private PrecheckRemediateHelper _helper = new PrecheckRemediateHelper();
    private Map<String, RemediateItem> _remediateItems;

    public RemediateItemBuilder() {
        this.initializeRemediateItemsMap();
    }

    public List<RemediateNode> getChildren(int parenId, RemediateHostConfigData preCheckValidationResults) {
        String remediateStatus = this._helper.getRemediateStatus(preCheckValidationResults);
        boolean isRemediateStatusPresentedInErrors = this.isRemediateStatusPresentedInErrorStatuses(remediateStatus);
        boolean isRemediateStatusPresentedInRemediateItems = this.isRemediateStatusPresentedInRemediateItems(remediateStatus);
        List<RemediateNode> children = new ArrayList<RemediateNode>();
        if (remediateStatus == null || isRemediateStatusPresentedInErrors || !isRemediateStatusPresentedInRemediateItems) {
            children = this._helper.createChildren(parenId, this._helper.getErrors(preCheckValidationResults));
        } else if ("success".equals(remediateStatus)) {
            children = this._helper.createChildren(parenId, this._helper.getTasks(preCheckValidationResults));
        }
        return children;
    }

    private boolean isRemediateStatusPresentedInRemediateItems(String remediateStatus) {
        return this._remediateItems.containsKey(remediateStatus);
    }

    private boolean isRemediateStatusPresentedInErrorStatuses(String remediateStatus) {
        HashSet<String> errorsStatuses = new HashSet<String>();
        errorsStatuses.add("failed");
        errorsStatuses.add("state_not_satisfied");
        return errorsStatuses.contains(remediateStatus);
    }

    private void initializeRemediateItemsMap() {
        this._remediateItems = new HashMap<String, RemediateItem>();
        this._remediateItems.put("failed", this._helper.createRemediateItem("remediateHostWizard.remediationResults.remediationFailed", "vx-icon-error"));
        this._remediateItems.put("state_not_satisfied", this._helper.createRemediateItem("remediateHostWizard.remediationResults.remediationCanNotStarted", "vx-icon-error"));
        this._remediateItems.put("reboot_failed", this._helper.createRemediateItem("remediateHostWizard.remediationResults.remediationRebootFailed", "vx-icon-warn"));
        this._remediateItems.put("exit_maintenancemode_failed", this._helper.createRemediateItem("remediateHostWizard.remediationResults.remediationMMExit", "vx-icon-warn"));
        this._remediateItems.put("canceled", this._helper.createRemediateItem("remediateHostWizard.remediationResults.remediationCanceled", "vx-icon-warn"));
        this._remediateItems.put("success", this._helper.createRemediateItem("remediateHostWizard.remediationResults.remediationSucceed", "vx-icon-compliant"));
    }
}

