/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.h5.impl;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.fault.InvalidProfileReferenceHost;
import com.vmware.vim.binding.vim.profile.ComplianceManager;
import com.vmware.vim.binding.vim.profile.Profile;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.hostprofile.HostProfileCompressUtil;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.cluster.h5.ClusterHostProfileComplianceCheckSpec;
import com.vmware.vsphere.client.hostprofile.cluster.impl.Util;
import com.vmware.vsphere.client.hostprofile.data.ImportProfileSpec;
import com.vmware.vsphere.client.hostprofile.impl.HostProfileMutationProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class H5HostProfileMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(HostProfileMutationProvider.class);

    public OperationResult apply(ManagedObjectReference clusterRef, ClusterHostProfileComplianceCheckSpec spec) {
        assert (clusterRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = clusterRef;
        try {
            if (clusterRef == null || spec == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("profile.error.invalidArguments"));
            }
            ServiceInstanceContent serviceContent = Util.getServiceInstanceContent(clusterRef);
            ManagedObjectReference hostProfileRef = spec.hostProfile;
            if (hostProfileRef == null) {
                hostProfileRef = Util.findAssociatedHostProfile(serviceContent, clusterRef);
            }
            if (hostProfileRef == null) {
                return result;
            }
            ComplianceManager manager = HostProfileUtils.getComplianceManager(clusterRef.getServerGuid());
            result.task = manager.checkCompliance(new ManagedObjectReference[]{hostProfileRef}, new ManagedObjectReference[]{clusterRef});
        }
        catch (Exception e) {
            _logger.error((Object)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, ImportProfileSpec zippedSpec) {
        OperationResult result = new OperationResult();
        HostProfile.SerializedHostProfileSpec spec = new HostProfile.SerializedHostProfileSpec();
        try {
            String hostProfileConfig = HostProfileCompressUtil.unzip(zippedSpec.compressedProfileConfig);
            spec.setProfileConfigString(hostProfileConfig);
            spec.setName(zippedSpec.name);
            spec.setAnnotation(zippedSpec.annotation);
            spec.setEnabled(Boolean.valueOf(zippedSpec.enabled));
            ProfileManager profileManager = HostProfileUtils.getProfileManager(vcRef.getServerGuid());
            spec.validating = true;
            ManagedObjectReference newProfile = null;
            try {
                newProfile = profileManager.createProfile((Profile.CreateSpec)spec);
            }
            catch (InvalidProfileReferenceHost noRefHostError) {
                spec.validating = false;
                newProfile = profileManager.createProfile((Profile.CreateSpec)spec);
            }
            result.result = newProfile;
        }
        catch (Exception e) {
            _logger.error((Object)"Import profile failed", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }
}

