/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.h5.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.http.transport.data.IDownloadHandler;
import com.vmware.vsphere.client.hostprofile.cluster.impl.Util;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HostCustomizationsDownloadService
implements IDownloadHandler {
    private static final String OBJECT_ID = "objectId";
    private static final String HOST_CUSTOMIZATIONS_EXPORT_DATA = "hostCustomizationsExportData";
    private static final String NAME = "name";
    private final QueryService _queryService;

    public HostCustomizationsDownloadService(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    public boolean canHandleDownloadRequest(HttpServletRequest request, String downloadPath) {
        return downloadPath != null && "hostcustomizations".equals(downloadPath);
    }

    public void download(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = request.getParameter(OBJECT_ID);
        if (objectId == null) {
            response.sendError(400, Util.getLocalizedString("downloadService.missingReference"));
            return;
        }
        ManagedObjectReference hostRef = ManagedObjectUtil.stringToMoref((String)objectId);
        if (!(ManagedObjectUtil.isOfType((ManagedObjectReference)hostRef, HostSystem.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)hostRef, HostProfile.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)hostRef, ClusterComputeResource.class))) {
            response.sendError(400, Util.getLocalizedString("downloadService.invalidReference"));
            return;
        }
        String entityName = "";
        ResultSet resultSet = this._queryService.select(new String[]{NAME}).from(new String[]{hostRef.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef).fetch();
        if (resultSet.getItems().isEmpty()) {
            response.sendError(400, Util.getLocalizedString("downloadService.invalidReference"));
            return;
        }
        ResourceItem resourceItem = (ResourceItem)resultSet.getItems().get(0);
        List values = resourceItem.getPropertyValues();
        if (!values.isEmpty()) {
            entityName = (String)values.get(0);
        }
        response.setContentType("text/csv;charset=UTF-8");
        String contentDispositionHeader = String.format("attachment; filename=\"%s_host_customizations.csv\"", entityName);
        response.setHeader("Content-Disposition", contentDispositionHeader);
        response.flushBuffer();
        this.downloadHostCustomizationsCsv(response, hostRef);
    }

    private void downloadHostCustomizationsCsv(HttpServletResponse response, ManagedObjectReference hostRef) throws IOException {
        ServletOutputStream servletOutputStream = response.getOutputStream();
        String result = this.getHostCustomizationsData(hostRef);
        servletOutputStream.write(result.getBytes("UTF-8"));
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    private String getHostCustomizationsData(ManagedObjectReference hostRef) {
        ResourceItem resourceItem;
        List values;
        String result = "";
        ResultSet resultSetHostCustomizations = this._queryService.select(new String[]{HOST_CUSTOMIZATIONS_EXPORT_DATA}).from(new String[]{hostRef.getType()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef).fetch();
        if (!resultSetHostCustomizations.getItems().isEmpty() && !(values = (resourceItem = (ResourceItem)resultSetHostCustomizations.getItems().get(0)).getPropertyValues()).isEmpty()) {
            result = (String)values.get(0);
        }
        return result;
    }
}

