/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.lookup.LookupService;
import java.util.Locale;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserSessionListenerImpl
implements UserSessionListener {
    private static final Log _logger = LogFactory.getLog(UserSessionListenerImpl.class);
    private final LookupService _lookupService;

    public UserSessionListenerImpl(LookupService lookupService) {
        this._lookupService = lookupService;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        SessionUtil.setData((String)"com.vmware.mhm", (Object)this.validateMhmServiceInstalled());
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
    }

    private boolean validateMhmServiceInstalled() {
        ServiceRegistration.EndpointType endpointType = new ServiceRegistration.EndpointType();
        endpointType.setType("com.vmware.gateway");
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setEndpointType(endpointType);
        Object[] infos = this._lookupService.getServiceRegistrationInfos(filter);
        if (!ArrayUtil.isNullOrEmpty((Object[])infos)) {
            for (Object info : infos) {
                String productId = info.getServiceType().getProduct();
                if (!"com.vmware.mhm".equals(productId)) continue;
                _logger.info((Object)"Multi-Hypervisor Manager service installed");
                return true;
            }
        }
        _logger.info((Object)"Multi-Hypervisor Manager service NOT installed");
        return false;
    }
}

