/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.IpmiInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.PropertyValidationNode;
import com.vmware.vise.data.mutation.MutationMapping;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.host.util.Util;

public class PowerConfigSoftwareProvider
implements PropertyProviderBean,
MutationProvider {
    private DataService _dataService;
    private LegacyAuthorizationService _authService;

    public PowerConfigSoftwareProvider(DataService dataService, LegacyAuthorizationService authService) {
        this._dataService = dataService;
        this._authService = authService;
    }

    @type(value="HostSystem")
    public DynamicObject getPowerConfigSoftware(ManagedObjectReference hostRef) throws Exception {
        IpmiInfo impiInfo = (IpmiInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"config.ipmi");
        String login = "";
        String bmcIpAddress = "";
        String bmcMacAddress = "";
        if (impiInfo != null) {
            if (impiInfo.login != null) {
                login = impiInfo.login;
            }
            if (impiInfo.bmcIpAddress != null) {
                bmcIpAddress = impiInfo.bmcIpAddress;
            }
            if (impiInfo.bmcMacAddress != null) {
                bmcMacAddress = impiInfo.bmcMacAddress;
            }
        }
        DynamicObject result = new DynamicObject();
        result.properties = new NameValuePair[]{new NameValuePair("login", (Object)login), new NameValuePair("password", (Object)""), new NameValuePair("bmcIpAddress", (Object)bmcIpAddress), new NameValuePair("bmcMacAddress", (Object)bmcMacAddress)};
        return result;
    }

    @ModelMetadata(type={"HostSystem"}, property="powerConfigSoftware.@info.immutable")
    public boolean getPowerConfigSoftwareImmutable(ManagedObjectReference hostRef) {
        return !Util.checkHostAvailability(hostRef, new String[]{"Host.Config.Settings"}, this._dataService, this._authService);
    }

    @MutationMapping(type="HostSystem", property="powerConfigSoftware")
    public OperationResult applyPowerConfigSoftware(ManagedObjectReference hostRef, DynamicObject args) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        try {
            IpmiInfo info = new IpmiInfo();
            info.login = PowerConfigSoftwareProvider.getValueAsString(args, "login");
            info.password = PowerConfigSoftwareProvider.getValueAsString(args, "password");
            info.bmcIpAddress = PowerConfigSoftwareProvider.getValueAsString(args, "bmcIpAddress");
            info.bmcMacAddress = PowerConfigSoftwareProvider.getValueAsString(args, "bmcMacAddress");
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            host.updateIpmi(info);
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    @MutationMapping(type="HostSystem", property="powerConfigSoftware")
    public ValidationResult validatePowerConfigSoftware(ManagedObjectReference hostRef, DynamicObject newVal) {
        ValidationResult validationResult = new ValidationResult();
        Boolean loginSet = !StringUtil.isNullOrEmpty((String)PowerConfigSoftwareProvider.getValueAsString(newVal, "login"));
        Boolean passwordSet = !StringUtil.isNullOrEmpty((String)PowerConfigSoftwareProvider.getValueAsString(newVal, "password"));
        Boolean bmcIpAddressSet = !StringUtil.isNullOrEmpty((String)PowerConfigSoftwareProvider.getValueAsString(newVal, "bmcIpAddress"));
        Boolean bmcMacAddressSet = !StringUtil.isNullOrEmpty((String)PowerConfigSoftwareProvider.getValueAsString(newVal, "bmcMacAddress"));
        if ((loginSet.booleanValue() || passwordSet.booleanValue() || bmcIpAddressSet.booleanValue() || bmcMacAddressSet.booleanValue()) && loginSet ^ passwordSet ^ bmcIpAddressSet ^ bmcMacAddressSet) {
            PropertyValidationNode propertyValidation = new PropertyValidationNode();
            propertyValidation.validationMessages = new String[]{Util.getLocalizedString("error.allParametersRequired")};
            validationResult.result = propertyValidation;
        }
        return validationResult;
    }

    private static String getValueAsString(DynamicObject dynObj, String name) {
        if (dynObj != null && dynObj.properties != null) {
            for (NameValuePair nvp : dynObj.properties) {
                if (!nvp.name.equalsIgnoreCase(name)) continue;
                return nvp.value.toString();
            }
        }
        return null;
    }
}

