/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client;

import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.lookup.ServiceEndpoint;
import com.vmware.vim.binding.lookup.ServiceRegistrationForm;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;

public class ServiceFormFactory {
    public static final String PROP_VERSION = "version";
    public static final String PROP_TYPE = "type";
    public static final String PROP_OWNER_ID = "ownerId";
    public static final String PROP_SERVICE_NAME = "serviceName";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_PRODUCT_ID = "productId";
    public static final String PROP_ENDPOINT = "endpoint";
    public static final String PROP_URL = "url";
    public static final String PROP_PROTOCOL = "protocol";
    public static final String PROP_SSL_TRUST = "ssltrust";

    public static ServiceRegistrationForm createForm(Properties props) throws Exception {
        ServiceRegistrationForm form = new ServiceRegistrationForm();
        form.setVersion(ServiceFormFactory.getRequiredProperty(props, PROP_VERSION));
        form.setType(URI.create(ServiceFormFactory.getRequiredProperty(props, PROP_TYPE)));
        form.setOwnerId(props.getProperty(PROP_OWNER_ID));
        form.setServiceName(props.getProperty(PROP_SERVICE_NAME));
        form.setDescription(props.getProperty(PROP_DESCRIPTION));
        form.setProductId(props.getProperty(PROP_PRODUCT_ID));
        form.setEndpoints(ServiceFormFactory.parseEndpoints(props));
        return form;
    }

    public static Service createService(String serviceId, Properties props) throws Exception {
        Service svc = new Service();
        svc.setServiceId(serviceId);
        svc.setVersion(ServiceFormFactory.getRequiredProperty(props, PROP_VERSION));
        svc.setType(URI.create(ServiceFormFactory.getRequiredProperty(props, PROP_TYPE)));
        svc.setOwnerId(props.getProperty(PROP_OWNER_ID));
        svc.setServiceName(props.getProperty(PROP_SERVICE_NAME));
        svc.setDescription(props.getProperty(PROP_DESCRIPTION));
        svc.setProductId(props.getProperty(PROP_PRODUCT_ID));
        svc.setEndpoints(ServiceFormFactory.parseEndpoints(props));
        return svc;
    }

    private static ServiceEndpoint[] parseEndpoints(Properties props) throws Exception {
        String name;
        ServiceEndpoint endpoint;
        ArrayList<ServiceEndpoint> endpoints = new ArrayList<ServiceEndpoint>();
        int i = 0;
        while ((endpoint = ServiceFormFactory.parseEndpoint(name = PROP_ENDPOINT + i + ".", props)) != null) {
            endpoints.add(endpoint);
            ++i;
        }
        return endpoints.toArray(new ServiceEndpoint[endpoints.size()]);
    }

    private static ServiceEndpoint parseEndpoint(String name, Properties props) throws Exception {
        String url = props.getProperty(name + PROP_URL);
        if (url == null) {
            return null;
        }
        ServiceEndpoint ep = new ServiceEndpoint();
        ep.setUrl(URI.create(url));
        String cert = props.getProperty(name + PROP_SSL_TRUST);
        if (cert != null) {
            ep.setSslTrustAnchor(cert);
        }
        ep.setProtocol(ServiceFormFactory.getRequiredProperty(props, name + PROP_PROTOCOL));
        return ep;
    }

    private static String getRequiredProperty(Properties props, String name) throws Exception {
        String value = props.getProperty(name);
        if (value == null) {
            throw new IllegalArgumentException(String.format("Missing required property '%s'", name));
        }
        return value;
    }
}

