/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool;

public class CliArgumentDescriptor {
    private final String _name;
    private final String _cliOption;
    private PARSER_ACTION _parserAction;
    private String _helpString;
    private Validator _validator;
    private static final Validator NONEMPTY_VALIDATOR = new Validator(){

        @Override
        public void validate(String value) {
            if (value == null || value.isEmpty()) {
                throw new IllegalArgumentException();
            }
        }
    };

    public CliArgumentDescriptor(String name, String cliOption) {
        this._name = name;
        this._cliOption = cliOption;
        this._parserAction = PARSER_ACTION.SINGLE_VALUE;
        this._helpString = "";
        this._validator = NONEMPTY_VALIDATOR;
    }

    public CliArgumentDescriptor setParserAction(PARSER_ACTION parserAction) {
        this._parserAction = parserAction;
        return this;
    }

    public CliArgumentDescriptor setHelpString(String helpString) {
        this._helpString = helpString;
        return this;
    }

    public CliArgumentDescriptor setValidator(Validator validator) {
        this._validator = validator;
        return this;
    }

    public String getName() {
        return this._name;
    }

    public String getCliOption() {
        return this._cliOption;
    }

    public PARSER_ACTION getParserAction() {
        return this._parserAction;
    }

    public String getHelpString() {
        return this._helpString;
    }

    public Validator getValidator() {
        return this._validator;
    }

    public static interface Validator {
        public void validate(String var1) throws Exception;
    }

    public static enum PARSER_ACTION {
        SWITCH,
        SINGLE_VALUE;

    }
}

