/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.command;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.lookup.client.tool.CliArgumentDescriptor;
import com.vmware.vim.lookup.client.tool.command.Command;
import com.vmware.vim.lookup.client.tool.command.OutputHelper;
import com.vmware.vim.lookup.client.tool.exception.CliInvalidArgumentException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Get55Command
extends Command {
    public Get55Command() {
        super("get55");
        this.setRequiredArguments(Get55Command.getRequiredArgs());
        this.setOptionalArguments(Get55Command.getOptionalArgs());
        this.setHelpString("Get VC55 service by its identifier");
    }

    private static List<CliArgumentDescriptor> getRequiredArgs() {
        return Arrays.asList(Command._knownArguments.get("url"), Command._knownArguments.get("id"));
    }

    private static List<CliArgumentDescriptor> getOptionalArgs() {
        return Arrays.asList(Command._knownArguments.get("as-spec"), Command._knownArguments.get("no-check-cert"));
    }

    @Override
    public String execute(Map<String, String> args) throws Exception {
        final String serviceId = args.get("id");
        final boolean printAsSpec = args.get("as-spec") != null;
        return Get55Command.callLs55(args, new Command.LsCall55(){

            @Override
            public String execute(LookupService ls) throws Exception {
                try {
                    Service svc = ls.findService(serviceId);
                    return printAsSpec ? OutputHelper.formatServiceAsSpec(svc) : OutputHelper.prettyFormatService(svc);
                }
                catch (InvalidArgument e) {
                    throw new CliInvalidArgumentException(String.format("Service doesn't exist with id '%s'", serviceId), e);
                }
            }
        });
    }
}

