/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.command;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import com.vmware.vim.lookup.client.tool.CliArgumentDescriptor;
import com.vmware.vim.lookup.client.tool.command.Command;
import com.vmware.vim.lookup.client.tool.command.OutputHelper;
import com.vmware.vim.lookup.client.tool.exception.CliInvalidArgumentException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class GetCommand
extends Command {
    public GetCommand() {
        super("get");
        this.setRequiredArguments(GetCommand.getRequiredArgs());
        this.setOptionalArguments(GetCommand.getOptionalArgs());
        this.setHelpString("Get service by its identifier");
    }

    private static List<CliArgumentDescriptor> getRequiredArgs() {
        return Arrays.asList(Command._knownArguments.get("url"), Command._knownArguments.get("id"));
    }

    private static List<CliArgumentDescriptor> getOptionalArgs() {
        return Arrays.asList(Command._knownArguments.get("as-spec"), Command._knownArguments.get("no-check-cert"));
    }

    @Override
    public String execute(Map<String, String> args) throws Exception {
        final String serviceId = args.get("id");
        final boolean printAsSpec = args.get("as-spec") != null;
        return GetCommand.callLs(args, new Command.LsCall(){

            @Override
            public String execute(ServiceRegistration ls) throws Exception {
                try {
                    ServiceRegistration.Info info = ls.get(serviceId);
                    return printAsSpec ? OutputHelper.formatServiceAsSpec(info) : OutputHelper.prettyFormatService(info);
                }
                catch (EntryNotFoundFault e) {
                    throw new CliInvalidArgumentException(String.format("Service doesn't exist with id '%s'", serviceId), e);
                }
            }
        });
    }
}

