/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.command;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.SearchCriteria;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.lookup.client.tool.CliArgumentDescriptor;
import com.vmware.vim.lookup.client.tool.command.Command;
import com.vmware.vim.lookup.client.tool.command.OutputHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class List55Command
extends Command {
    private static final String ARGNAME_TYPE = "type";

    public List55Command() {
        super("list55");
        this.setRequiredArguments(List55Command.getRequiredArgs());
        this.setOptionalArguments(List55Command.getOptionalArgs());
        this.setHelpString("List VC55 service registrations using specified search criteria");
    }

    private static List<CliArgumentDescriptor> getRequiredArgs() {
        return Arrays.asList(Command._knownArguments.get("url"));
    }

    private static List<CliArgumentDescriptor> getOptionalArgs() {
        ArrayList<CliArgumentDescriptor> args = new ArrayList<CliArgumentDescriptor>();
        args.add(Command._knownArguments.get("no-check-cert"));
        args.add(Command._knownArguments.get("as-spec"));
        args.add(Command._knownArguments.get("id-only"));
        args.add(new CliArgumentDescriptor(ARGNAME_TYPE, "--type").setHelpString("Service type value of search criteria"));
        return args;
    }

    @Override
    public String execute(Map<String, String> args) throws Exception {
        final SearchCriteria crit = List55Command.getSearchCriteria(args);
        final boolean printAsSpec = args.get("as-spec") != null;
        final boolean printIdOnly = args.get("id-only") != null;
        return List55Command.callLs55(args, new Command.LsCall55(){

            @Override
            public String execute(LookupService ls) throws Exception {
                crit.setViSite(ls.getViSite());
                Service[] svcs = ls.find(crit);
                StringBuilder sbIDs = new StringBuilder();
                StringBuilder sbSvcs = new StringBuilder();
                boolean firstTime = true;
                for (Service svc : svcs) {
                    sbIDs.append(svc.getServiceId()).append("\n");
                    if (!firstTime) {
                        sbSvcs.append("-------------------------------------------------------\n");
                    }
                    sbSvcs.append(printAsSpec ? OutputHelper.formatServiceAsSpec(svc) : OutputHelper.prettyFormatService(svc));
                    firstTime = false;
                }
                return printIdOnly ? sbIDs.toString() : sbSvcs.toString();
            }
        });
    }

    private static SearchCriteria getSearchCriteria(Map<String, String> args) {
        SearchCriteria crit = new SearchCriteria();
        String svcType = args.get(ARGNAME_TYPE);
        if (svcType != null) {
            crit.setServiceType(URI.create(svcType));
        }
        return crit;
    }
}

