/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.command;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.fault.EntryExistsFault;
import com.vmware.vim.lookup.client.LookupSpecFactory;
import com.vmware.vim.lookup.client.tool.CliArgumentDescriptor;
import com.vmware.vim.lookup.client.tool.command.Command;
import com.vmware.vim.lookup.client.tool.exception.CliInvalidArgumentException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RegisterCommand
extends Command {
    public RegisterCommand() {
        super("register");
        this.setRequiredArguments(RegisterCommand.getRequiredArgs());
        this.setOptionalArguments(RegisterCommand.getOptionalArgs());
        this.setHelpString("Register service");
    }

    private static List<CliArgumentDescriptor> getRequiredArgs() {
        return Arrays.asList(Command._knownArguments.get("url"), Command._knownArguments.get("user"), Command._knownArguments.get("password"), Command._knownArguments.get("spec"), Command._knownArguments.get("id"));
    }

    private static List<CliArgumentDescriptor> getOptionalArgs() {
        return Arrays.asList(Command._knownArguments.get("no-check-cert"));
    }

    @Override
    public String execute(Map<String, String> args) throws Exception {
        final String serviceId = args.get("id");
        final ServiceRegistration.CreateSpec spec = RegisterCommand.createSpec(args);
        return RegisterCommand.callLs(args, new Command.LsCall(){

            @Override
            public String execute(ServiceRegistration ls) throws Exception {
                try {
                    ls.create(serviceId, spec);
                }
                catch (EntryExistsFault e) {
                    throw new CliInvalidArgumentException(String.format("Service already exists with id '%s'", serviceId), e);
                }
                return "";
            }
        });
    }

    private static ServiceRegistration.CreateSpec createSpec(Map<String, String> args) throws Exception {
        String specFile = args.get("spec");
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(specFile));
        }
        catch (IOException e) {
            throw new CliInvalidArgumentException(String.format("Failed to open specified spec file '%s'", specFile), e);
        }
        try {
            return LookupSpecFactory.createCreateSpec(props);
        }
        catch (Exception e) {
            throw new CliInvalidArgumentException(String.format("Failed to create service spec from file '%s'", specFile), e);
        }
    }
}

