/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.command;

import com.vmware.vim.binding.lookup.LookupService;
import com.vmware.vim.binding.lookup.Service;
import com.vmware.vim.lookup.client.ServiceFormFactory;
import com.vmware.vim.lookup.client.tool.CliArgumentDescriptor;
import com.vmware.vim.lookup.client.tool.command.Command;
import com.vmware.vim.lookup.client.tool.exception.CliInvalidArgumentException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Reregister55Command
extends Command {
    public Reregister55Command() {
        super("reregister55");
        this.setRequiredArguments(Reregister55Command.getRequiredArgs());
        this.setOptionalArguments(Reregister55Command.getOptionalArgs());
        this.setHelpString("Update VC55 service registration");
    }

    private static List<CliArgumentDescriptor> getRequiredArgs() {
        return Arrays.asList(Command._knownArguments.get("url"), Command._knownArguments.get("user"), Command._knownArguments.get("password"), Command._knownArguments.get("spec"), Command._knownArguments.get("id"));
    }

    private static List<CliArgumentDescriptor> getOptionalArgs() {
        return Arrays.asList(Command._knownArguments.get("no-check-cert"));
    }

    @Override
    public String execute(Map<String, String> args) throws Exception {
        String serviceId = args.get("id");
        final Service svc = Reregister55Command.createService(serviceId, args.get("spec"));
        return Reregister55Command.callLs55(args, new Command.LsCall55(){

            @Override
            public String execute(LookupService ls) throws Exception {
                svc.setViSite(ls.getViSite());
                ls.updateService(svc);
                return "";
            }
        });
    }

    private static Service createService(String serviceId, String specFile) throws Exception {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(specFile));
        }
        catch (IOException e) {
            throw new CliInvalidArgumentException(String.format("Failed to open specified spec file '%s'", specFile), e);
        }
        try {
            return ServiceFormFactory.createService(serviceId, props);
        }
        catch (Exception e) {
            throw new CliInvalidArgumentException(String.format("Failed to create registration form from file '%s'", specFile), e);
        }
    }
}

