/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.command;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import com.vmware.vim.lookup.client.tool.CliArgumentDescriptor;
import com.vmware.vim.lookup.client.tool.command.Command;
import com.vmware.vim.lookup.client.tool.exception.CliInvalidArgumentException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class UnregisterCommand
extends Command {
    public UnregisterCommand() {
        super("unregister");
        this.setRequiredArguments(UnregisterCommand.getRequiredArgs());
        this.setOptionalArguments(UnregisterCommand.getOptionalArgs());
        this.setHelpString("Delete service registration");
    }

    private static List<CliArgumentDescriptor> getRequiredArgs() {
        return Arrays.asList(Command._knownArguments.get("url"), Command._knownArguments.get("user"), Command._knownArguments.get("password"), Command._knownArguments.get("id"));
    }

    private static List<CliArgumentDescriptor> getOptionalArgs() {
        return Arrays.asList(Command._knownArguments.get("no-check-cert"));
    }

    @Override
    public String execute(Map<String, String> args) throws Exception {
        final String serviceId = args.get("id");
        return UnregisterCommand.callLs(args, new Command.LsCall(){

            @Override
            public String execute(ServiceRegistration ls) throws Exception {
                try {
                    ls.delete(serviceId);
                }
                catch (EntryNotFoundFault e) {
                    throw new CliInvalidArgumentException(String.format("Service doesn't exist with id '%s'", serviceId), e);
                }
                return "";
            }
        });
    }
}

