/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.lookup.client.tool.util;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.lookup.client.tool.exception.SsoNotFoundException;
import com.vmware.vim.lookup.client.tool.exception.TokenAcquisitionException;
import com.vmware.vim.lookup.client.tool.util.AllowAllThumbprintVerifier;
import com.vmware.vim.lookup.client.tool.util.SsoConnConfig;
import com.vmware.vim.lookup.client.tool.util.SsoEndpointUtil;
import com.vmware.vim.sso.admin.client.AdminClient;
import com.vmware.vim.sso.admin.client.AdminClientFactory;
import com.vmware.vim.sso.admin.client.vmomi.VmomiClientConfiguration;
import com.vmware.vim.sso.admin.client.vmomi.VmomiClientFactory;
import com.vmware.vim.sso.client.DefaultSecurityTokenServiceFactory;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenService;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.CertificateValidationException;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.TokenRequestRejectedException;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.impl.SslUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;

public class SamlTokenUtil {
    private static final HashMap<Class<? extends Exception>, String> _exceptionDesc = new HashMap();

    public static SamlToken acquireBearerToken(ServiceRegistration ls, String userName, String password, KeyStore ks) throws TokenAcquisitionException, SsoNotFoundException {
        SsoConnConfig connConfig = SsoEndpointUtil.createSsoConnConfig(ls);
        try {
            return SamlTokenUtil.createStsClient(connConfig, ks).acquireToken(userName, password, SamlTokenUtil.createTokenSpec(60L));
        }
        catch (Exception e) {
            throw new TokenAcquisitionException(_exceptionDesc.get(e.getClass()), e);
        }
    }

    private static SecurityTokenService createStsClient(SsoConnConfig connInfo, KeyStore ks) throws MalformedURLException, Exception {
        SsoConnConfig.EndpointConnConfig sts = connInfo.get(SsoConnConfig.EndpointType.STS);
        SsoConnConfig.EndpointConnConfig admin = connInfo.get(SsoConnConfig.EndpointType.ADMIN);
        AllowAllThumbprintVerifier v = ks == null ? new AllowAllThumbprintVerifier() : null;
        Set<X509Certificate> signingCerts = SamlTokenUtil.getSigningCertificates(admin.getUrl(), ks, v);
        X509Certificate[] certs = null;
        String thumbprint = null;
        if (ks != null) {
            certs = SamlTokenUtil.fetchCertificates(ks);
        } else {
            X509Certificate[] capturedChain = v.getCapturedCertificateChain();
            if (capturedChain != null && capturedChain.length > 0) {
                thumbprint = SslUtil.computeCertificateThumbprint((X509Certificate)capturedChain[0]);
            }
        }
        SecurityTokenServiceConfig.ConnectionConfig connConfig = new SecurityTokenServiceConfig.ConnectionConfig(sts.getUrl().toURL(), certs, thumbprint);
        SecurityTokenServiceConfig stsConfig = new SecurityTokenServiceConfig(connConfig, SamlTokenUtil.toCertArray(signingCerts), null);
        return DefaultSecurityTokenServiceFactory.getSecurityTokenService((SecurityTokenServiceConfig)stsConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<X509Certificate> getSigningCertificates(URI adminUrl, KeyStore ks, ThumbprintVerifier tv) throws Exception {
        VmomiClientConfiguration.Builder builder = new VmomiClientConfiguration.Builder(adminUrl, VmomiClientConfiguration.Version.Version2);
        builder.setSslConfiguration(new VmomiClientConfiguration.SslConfiguration(tv, ks, null));
        VmomiClientConfiguration ssoAdminConfig = builder.createConfig();
        AdminClientFactory factory = VmomiClientFactory.createAdminClientFactory((VmomiClientConfiguration)ssoAdminConfig);
        AdminClient adminClient = null;
        Set certs = null;
        try {
            adminClient = factory.createAdminClient();
            certs = adminClient.getServerConfigurator().getIssuersCertificates();
        }
        finally {
            if (adminClient != null) {
                adminClient.dispose();
            }
        }
        return certs;
    }

    private static TokenSpec createTokenSpec(long tokenLifetimeSecs) {
        TokenSpec.Builder builder = new TokenSpec.Builder(tokenLifetimeSecs);
        return builder.createTokenSpec();
    }

    private static X509Certificate[] fetchCertificates(KeyStore ks) throws Exception {
        ArrayList<X509Certificate> ret = new ArrayList<X509Certificate>();
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            ret.add((X509Certificate)ks.getCertificate(aliases.nextElement()));
        }
        return SamlTokenUtil.toCertArray(ret);
    }

    private static X509Certificate[] toCertArray(Collection<X509Certificate> certs) {
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    static {
        _exceptionDesc.put(InvalidTokenException.class, "Token returned from SSO is invalid (e.g., signing certificate cannot be verified, token already expired, etc)");
        _exceptionDesc.put(TokenRequestRejectedException.class, "Token request is rejected (e.g., wrong SSO user name and password)");
        _exceptionDesc.put(CertificateValidationException.class, "Cannot Validate SSO's SSL certificate");
        _exceptionDesc.put(MalformedURLException.class, "SSO URL retrieved from lookup service is not valid");
    }
}

