/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging;

import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vmodl.fault.SecurityError;
import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vim.query.client.AuthenticationStrategy;
import com.vmware.vim.query.client.Client;
import com.vmware.vim.query.client.ClientFactory;
import com.vmware.vim.query.client.exception.ClientException;
import com.vmware.vim.query.client.impl.ClientFactoryImpl;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.ServiceEndpointType;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vmomi.vc.VcAwareSharedHttpConfigPool;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.tagging.Util;
import com.vmware.vsphere.client.tagging.exception.AuthenticationException;
import com.vmware.vsphere.client.tagging.exception.HostConnectException;
import com.vmware.vsphere.client.tagging.impl.TagServiceImpl;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.http.conn.HttpHostConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryClientManager {
    private static final Logger _logger = LoggerFactory.getLogger(QueryClientManager.class);
    private final VcAwareSharedHttpConfigPool _httpConfigPool;
    private final ClientFactory _clientFactory = new ClientFactoryImpl();
    private final SsoService _ssoService;

    public QueryClientManager(SsoService ssoService, VcAwareSharedHttpConfigPool vcAwareSharedHttpConfigPool) {
        this._ssoService = ssoService;
        this._httpConfigPool = vcAwareSharedHttpConfigPool;
    }

    public Client createClient(VcService vcService) throws HostConnectException, AuthenticationException {
        ServiceEndpointEx serviceEndpointEx = this.getInventoryServiceEndpoint(vcService);
        String string = this.getSearchUrl((ServiceDirectory.ServiceEndpoint)serviceEndpointEx, vcService);
        SamlToken samlToken = AuthSessionUtil.getSsoToken();
        PrivateKey privateKey = this._ssoService.getHokPrivateKey();
        Client client = this.createClientWithRetry((ServiceDirectory.ServiceEndpoint)serviceEndpointEx, string, samlToken, privateKey);
        return client;
    }

    public void closeClient(Client client, VcService vcService) throws IllegalArgumentException, CompositeException {
        if (client == null || vcService == null) {
            throw new IllegalArgumentException("The passed client or vcService is null");
        }
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        ServiceEndpointEx serviceEndpointEx = this.getInventoryServiceEndpoint(vcService);
        try {
            if (client.getAuthenticationManager() != null) {
                client.getAuthenticationManager().logout();
            }
        }
        catch (Exception exception) {
            _logger.error("Error logging out of " + (serviceEndpointEx == null ? "???" : serviceEndpointEx.getUrl()), (Throwable)exception);
            arrayList.add(exception);
        }
        try {
            client.close();
        }
        catch (Exception exception) {
            _logger.error("Error while trying to close client: ", (Throwable)exception);
            arrayList.add(exception);
        }
        try {
            this._httpConfigPool.releaseHttpConfig((ServiceDirectory.ServiceEndpoint)serviceEndpointEx, false);
        }
        catch (Exception exception) {
            _logger.error("Error releasing the client http configuration ", (Throwable)exception);
            arrayList.add(exception);
        }
        if (arrayList.size() != 0) {
            throw new CompositeException(arrayList);
        }
    }

    private ServiceEndpointEx getInventoryServiceEndpoint(VcService vcService) {
        String string = vcService.getServiceGuid();
        for (ServiceEndpointEx serviceEndpointEx : vcService.getServiceEndPoints()) {
            String string2;
            ServiceEndpointType serviceEndpointType = serviceEndpointEx.getServiceEndpointType();
            if (serviceEndpointType != ServiceEndpointType.IS || !string.equals(string2 = serviceEndpointEx.getVcGuid())) continue;
            return serviceEndpointEx;
        }
        throw MixedUtil.getRuntimeFault((String)"inventory-service-endpoint-not-found-error");
    }

    private String getSearchUrl(ServiceDirectory.ServiceEndpoint serviceEndpoint, VcService vcService) {
        String string = serviceEndpoint.getUrl();
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (uRI == null) {
            return string;
        }
        try {
            InetAddress.getByName(uRI.getHost());
            return string;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {
            return string;
        }
        String string2 = null;
        if (vcService != null) {
            string2 = vcService.getServiceUrl();
        }
        try {
            URI uRI2 = new URI(string2);
            String string3 = uRI2.getHost();
            String string4 = uRI.getHost();
            string = string.replaceFirst(string4, string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return string;
    }

    private Client createClientWithRetry(ServiceDirectory.ServiceEndpoint serviceEndpoint, String string, SamlToken samlToken, PrivateKey privateKey) throws AuthenticationException, HostConnectException {
        try {
            Client client = this.createClientForEndpoint(serviceEndpoint, string, samlToken, privateKey);
            return client;
        }
        catch (CertificateValidationException certificateValidationException) {
            URI uRI = URI.create(string);
            String string2 = Util.formatLogMessage(uRI.toString(), "Query service threw a CertificateValidationException, seems like its thumbprint has changed. New thumbprint: %1$s.", certificateValidationException.getThumbprint());
            _logger.error(string2, (Throwable)certificateValidationException);
            try {
                ServiceDirectory.ServiceEndpoint serviceEndpoint2 = VcServiceUtil.fetchServiceEndpoint((String)serviceEndpoint.instanceUuid);
                this._httpConfigPool.updateThumbprint(serviceEndpoint2);
                Client client = this.createClientForEndpoint(serviceEndpoint2, string, samlToken, privateKey);
                return client;
            }
            catch (Exception exception) {
                _logger.error("Retrying to create the query client failed: ", (Throwable)exception);
                throw new AuthenticationException("Unable to create query client: ", certificateValidationException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client createClientForEndpoint(ServiceDirectory.ServiceEndpoint serviceEndpoint, String string, SamlToken samlToken, PrivateKey privateKey) throws AuthenticationException, HostConnectException, CertificateValidationException {
        if (samlToken == null) {
            String string2 = "No SAML token found. Cannot login to Inventory Service " + string;
            _logger.error(string2);
            throw new AuthenticationException("The provided SAML token is null.");
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(TagServiceImpl.class.getClassLoader());
        try {
            URI uRI = URI.create(string);
            String string3 = uRI.toString();
            HttpConfiguration httpConfiguration = this._httpConfigPool.getHttpConfig(serviceEndpoint);
            HttpClientConfiguration httpClientConfiguration = HttpClientConfiguration.Factory.newInstance();
            httpClientConfiguration.setHttpConfiguration(httpConfiguration);
            TaggingServiceAutenticationStrategy taggingServiceAutenticationStrategy = new TaggingServiceAutenticationStrategy();
            ClientFactoryConfiguration clientFactoryConfiguration = new ClientFactoryConfiguration(httpClientConfiguration, taggingServiceAutenticationStrategy);
            String string4 = SessionUtil.getSessionInfo();
            _logger.info("Creating a Query Client... " + string + " (" + string4 + ")");
            Client client = this._clientFactory.createClient(uRI, (ClientFactory.Configuration)clientFactoryConfiguration);
            try {
                this.loginBySamlToken(string, samlToken, privateKey, client);
                _logger.info(Util.formatLogMessage(string3, "Login request succeeded.", new Object[0]));
            }
            catch (ClientException clientException) {
                client.close();
                this._httpConfigPool.releaseHttpConfig(serviceEndpoint, false);
                this.translateClientException(clientException, string3, samlToken);
            }
            catch (RuntimeException runtimeException) {
                client.close();
                this._httpConfigPool.releaseHttpConfig(serviceEndpoint, false);
                if (runtimeException instanceof SystemError) {
                    throw new AuthenticationException("Cannot login to " + uRI.toString(), runtimeException);
                }
                throw runtimeException;
            }
            _logger.info("Done creating the Query Client (" + string4 + ", identity " + Integer.toHexString(System.identityHashCode(client)) + ")");
            Client client2 = client;
            return client2;
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    private void translateClientException(ClientException clientException, String string, SamlToken samlToken) throws HostConnectException, CertificateValidationException, AuthenticationException {
        Throwable throwable = clientException.getCause();
        if (throwable instanceof ExecutionException && throwable.getCause() != null) {
            throwable = ((ExecutionException)throwable).getCause();
        }
        if (throwable instanceof ConnectionException || throwable instanceof HttpHostConnectException || throwable instanceof SocketException || throwable instanceof TransportProtocolException || Util.isServiceUnavailable(throwable)) {
            throw new HostConnectException(string, throwable);
        }
        String string2 = "(" + SessionUtil.getSessionInfo() + ")";
        if (throwable instanceof SslException || throwable instanceof CertificateValidationException) {
            if (throwable instanceof SslException && throwable.getCause() instanceof CertificateValidationException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof CertificateValidationException) {
                CertificateValidationException certificateValidationException = (CertificateValidationException)throwable;
                throw certificateValidationException;
            }
            _logger.error(Util.formatLogMessage(string, "Invalid certificate. " + string2, new Object[0]), throwable);
            throw new HostConnectException(string, throwable);
        }
        if (throwable instanceof SecurityError) {
            _logger.info("[Server: {}] SecurityError in login request {}. Login token: subject = {} ; renewable = {} ; expiration time = {}", new Object[]{string, string2, samlToken.getSubject(), samlToken.isRenewable(), samlToken.getExpirationTime()});
        } else {
            _logger.warn(Util.formatLogMessage(string, "Error in login request. " + string2, new Object[0]), (Throwable)clientException);
        }
        throw new AuthenticationException("Cannot login to " + string, throwable);
    }

    private void loginBySamlToken(String string, SamlToken samlToken, PrivateKey privateKey, Client client) throws ClientException {
        if (_logger.isInfoEnabled()) {
            URI uRI = URI.create(string);
            _logger.info(Util.formatLogMessage(uRI.toString(), "Logging in using SAML token. Token expiration time: " + samlToken.getExpirationTime(), new Object[0]));
        }
        try {
            client.getAuthenticationManager().loginBySamlToken(samlToken, privateKey);
        }
        catch (TransportProtocolException transportProtocolException) {
            _logger.warn("Unable to login to: " + string + ", retrying.");
            client.getAuthenticationManager().loginBySamlToken(samlToken, privateKey);
        }
    }

    private class TaggingServiceAutenticationStrategy
    implements AuthenticationStrategy {
        private static final int MAX_LOGIN_ATTEMPTS = 3;

        private TaggingServiceAutenticationStrategy() {
        }

        public void login(Client client) {
            try {
                client.getAuthenticationManager().loginBySamlToken(AuthSessionUtil.getSsoToken(), QueryClientManager.this._ssoService.getHokPrivateKey());
            }
            catch (Exception exception) {
                _logger.error("The tagging service query client's attempt to re-login was unsuccessful.", (Throwable)exception);
            }
        }

        public int getMaxLoginAttempts() {
            return 3;
        }
    }

    private static class ClientFactoryConfiguration
    implements ClientFactory.Configuration {
        private final HttpClientConfiguration _httpClientConfig;
        private final AuthenticationStrategy _authStrategy;

        public ClientFactoryConfiguration(HttpClientConfiguration httpClientConfiguration, AuthenticationStrategy authenticationStrategy) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{httpClientConfiguration});
            this._httpClientConfig = httpClientConfiguration;
            this._authStrategy = authenticationStrategy;
        }

        public HttpClientConfiguration getClientConfig() {
            return this._httpClientConfig;
        }

        public Class<?> getVersion() {
            return null;
        }

        public AuthenticationStrategy getAuthenticationStrategy() {
            return this._authStrategy;
        }
    }
}

