/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging.impl;

import com.vmware.vim.binding.dataservice.QName;
import com.vmware.vim.binding.dataservice.fault.AlreadyExistsFault;
import com.vmware.vim.binding.dataservice.tagging.CategoryInfo;
import com.vmware.vim.binding.impl.dataservice.QNameImpl;
import com.vmware.vim.binding.impl.dataservice.tagging.CategoryInfoImpl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.search.impl.NamespaceUtils;
import com.vmware.vise.util.xml.NamespaceUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.tagging.CategoryCreateSpec;
import com.vmware.vsphere.client.tagging.TagService;
import com.vmware.vsphere.client.tagging.TagServiceLocator;
import com.vmware.vsphere.client.tagging.Util;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CategoryMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(CategoryMutationProvider.class);
    private static final String DEFAULT_NAMESPACE_PREFIX = "urn:";
    private final TagServiceLocator _tagServiceLocator;

    public CategoryMutationProvider(TagServiceLocator tagServiceLocator) {
        this._tagServiceLocator = tagServiceLocator;
    }

    private static QName[] typeSpecsToQNames(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        LinkedList<QNameImpl> linkedList = new LinkedList<QNameImpl>();
        for (String string : stringArray) {
            String string2 = DEFAULT_NAMESPACE_PREFIX + NamespaceUtils.getNamespace((String)string);
            String string3 = NamespaceUtil.getUnqualifiedTypeName((String)string);
            QNameImpl qNameImpl = new QNameImpl(string2, string3);
            linkedList.add(qNameImpl);
        }
        return linkedList.toArray(new QName[linkedList.size()]);
    }

    public OperationResult add(CategoryCreateSpec categoryCreateSpec) {
        return this.addMulti(new CategoryCreateSpec[]{categoryCreateSpec})[0];
    }

    public OperationResult[] addMulti(CategoryCreateSpec[] categoryCreateSpecArray) {
        LinkedList<OperationResult> linkedList = new LinkedList<OperationResult>();
        try {
            Util.checkNotNull(categoryCreateSpecArray, "specs");
            if (categoryCreateSpecArray.length > 0) {
                for (CategoryCreateSpec categoryCreateSpec : categoryCreateSpecArray) {
                    TagService tagService = this._tagServiceLocator.getTagService(null);
                    OperationResult operationResult = new OperationResult();
                    operationResult.entity = operationResult.result = this.createCategory(tagService, categoryCreateSpec);
                    linkedList.add(operationResult);
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"A problem occurred while creating categories", (Throwable)exception);
            OperationResult operationResult = new OperationResult();
            operationResult.error = exception.getCause() instanceof InvalidArgument ? MixedUtil.getRuntimeFault((String)Util.getLocalizedString("error.invalidNameInput")) : (exception.getCause() instanceof AlreadyExistsFault ? MixedUtil.getRuntimeFault((String)Util.getLocalizedString("tag.create.form.error.category.duplicate")) : MixedUtil.getMethodFault((Throwable)exception));
            linkedList.add(operationResult);
        }
        return linkedList.toArray(new OperationResult[linkedList.size()]);
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, CategoryCreateSpec categoryCreateSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            Util.checkNotNull(managedObjectReference, "moRef");
            Util.checkNotNull((Object)categoryCreateSpec, "spec");
            TagService tagService = this._tagServiceLocator.getTagService(null);
            CategoryInfoImpl categoryInfoImpl = new CategoryInfoImpl();
            categoryInfoImpl.setName(categoryCreateSpec.categoryName);
            categoryInfoImpl.setDescription(categoryCreateSpec.categoryDescription);
            categoryInfoImpl.setCardinality(categoryCreateSpec.multipleCardinality ? CategoryInfo.Cardinality.multiple : CategoryInfo.Cardinality.single);
            QName[] qNameArray = CategoryMutationProvider.typeSpecsToQNames(categoryCreateSpec.associableEntityTypes);
            categoryInfoImpl.setAssociableEntityType(qNameArray);
            tagService.updateCategory(managedObjectReference, (CategoryInfo)categoryInfoImpl);
        }
        catch (Exception exception) {
            _logger.error((Object)"A problem occurred while updating category details", (Throwable)exception);
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    public OperationResult remove(ManagedObjectReference managedObjectReference, CategoryCreateSpec categoryCreateSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            Util.checkNotNull(managedObjectReference, "moRef");
            TagService tagService = this._tagServiceLocator.getTagService(null);
            tagService.deleteCategory(managedObjectReference);
        }
        catch (Exception exception) {
            _logger.error((Object)"A problem occurred while deleting a category", (Throwable)exception);
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    private ManagedObjectReference createCategory(TagService tagService, CategoryCreateSpec categoryCreateSpec) throws InterruptedException, ExecutionException {
        CategoryInfoImpl categoryInfoImpl = new CategoryInfoImpl();
        categoryInfoImpl.setName(categoryCreateSpec.categoryName);
        categoryInfoImpl.setDescription(categoryCreateSpec.categoryDescription);
        categoryInfoImpl.setCardinality(categoryCreateSpec.multipleCardinality ? CategoryInfo.Cardinality.multiple : CategoryInfo.Cardinality.single);
        QName[] qNameArray = CategoryMutationProvider.typeSpecsToQNames(categoryCreateSpec.associableEntityTypes);
        categoryInfoImpl.setAssociableEntityType(qNameArray);
        return tagService.createCategory((CategoryInfo)categoryInfoImpl);
    }
}

