/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.tagging.impl;

import com.vmware.vim.binding.dataservice.fault.InvalidTagAssociationFault;
import com.vmware.vim.binding.dataservice.tagging.TagInfo;
import com.vmware.vim.binding.dataservice.tagging.TagManager;
import com.vmware.vim.binding.impl.dataservice.tagging.TagInfoImpl;
import com.vmware.vim.binding.vmodl.DynamicData;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.tagging.TagAttachSpec;
import com.vmware.vsphere.client.tagging.TagCreateSpec;
import com.vmware.vsphere.client.tagging.TagDetachSpec;
import com.vmware.vsphere.client.tagging.TagService;
import com.vmware.vsphere.client.tagging.TagServiceLocator;
import com.vmware.vsphere.client.tagging.Util;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TagMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(TagMutationProvider.class);
    private static final int RETRY_COUNT = 20;
    private static final long RETRY_INTERVAL = 5000L;
    private final DataService _dataService;
    private final TagServiceLocator _tagServiceLocator;
    private final ObjectReferenceService _objRefService;

    public TagMutationProvider(DataService dataService, ObjectReferenceService objectReferenceService, TagServiceLocator tagServiceLocator) {
        this._dataService = dataService;
        this._objRefService = objectReferenceService;
        this._tagServiceLocator = tagServiceLocator;
    }

    public OperationResult add(TagCreateSpec tagCreateSpec) {
        return this.addMulti(new TagCreateSpec[]{tagCreateSpec})[0];
    }

    public OperationResult[] addMulti(TagCreateSpec[] tagCreateSpecArray) {
        Util.checkNotNull(tagCreateSpecArray, "specs");
        if (tagCreateSpecArray.length == 0) {
            return new OperationResult[0];
        }
        LinkedList<OperationResult> linkedList = new LinkedList<OperationResult>();
        List<TagCreateSpec> list = Arrays.asList(tagCreateSpecArray);
        ArrayList<TagCreateSpec> arrayList = new ArrayList<TagCreateSpec>();
        int n = 20;
        try {
            while (n-- > 0) {
                for (TagCreateSpec tagCreateSpec : list) {
                    OperationResult operationResult;
                    try {
                        TagService tagService = this._tagServiceLocator.getTagService(null);
                        operationResult = new OperationResult();
                        ManagedObjectReference managedObjectReference = this.createTag(tagService, tagCreateSpec);
                        operationResult.entity = operationResult.result = managedObjectReference;
                        linkedList.add(operationResult);
                        if (tagCreateSpec.attachSpec == null) continue;
                        this.apply(managedObjectReference, tagCreateSpec.attachSpec);
                        operationResult.effect = new OperationEffect();
                        operationResult.effect.affectedEntites = tagCreateSpec.attachSpec.resources;
                    }
                    catch (Exception exception) {
                        if (exception.getCause() instanceof ManagedObjectNotFound && n > 0) {
                            arrayList.add(tagCreateSpec);
                            continue;
                        }
                        _logger.error((Object)"An error occurred while creating tags", (Throwable)exception);
                        operationResult = new OperationResult();
                        operationResult.error = exception.getCause() instanceof InvalidArgument ? MixedUtil.getRuntimeFault((String)Util.getLocalizedString("error.invalidNameInput")) : MixedUtil.getMethodFault((Throwable)exception);
                        linkedList.add(operationResult);
                    }
                }
                if (arrayList.size() != 0) {
                    list = arrayList;
                    arrayList = new ArrayList();
                    Thread.sleep(5000L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            _logger.error((Object)interruptedException);
        }
        return linkedList.toArray(new OperationResult[linkedList.size()]);
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, TagCreateSpec tagCreateSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            Util.checkNotNull(managedObjectReference, "moRef");
            Util.checkNotNull((Object)tagCreateSpec, "spec");
            TagService tagService = this._tagServiceLocator.getTagService(null);
            TagInfoImpl tagInfoImpl = new TagInfoImpl();
            tagInfoImpl.setName(tagCreateSpec.tagName);
            tagInfoImpl.setDescription(tagCreateSpec.tagDescription);
            tagService.updateTag(managedObjectReference, (TagInfo)tagInfoImpl);
        }
        catch (Exception exception) {
            _logger.error((Object)"An error occurred while updating tag details", (Throwable)exception);
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, TagAttachSpec tagAttachSpec) {
        OperationResult operationResult = new OperationResult();
        int n = 20;
        try {
            Util.checkNotNull(tagAttachSpec, "spec");
            Util.checkNotNull(tagAttachSpec.resources, "spec.resources");
            operationResult.entity = tagAttachSpec.resources[0];
            if (tagAttachSpec.resources.length > 1) {
                operationResult.effect = new OperationEffect();
                operationResult.effect.affectedEntites = Arrays.copyOfRange(tagAttachSpec.resources, 1, tagAttachSpec.resources.length);
            }
            Map<String, List<URI>> map = this.getObjectServerGuidToUriMap(tagAttachSpec.resources);
            HashMap<String, List<URI>> hashMap = new HashMap<String, List<URI>>();
            ArrayList<Exception> arrayList = new ArrayList<Exception>();
            while (n-- > 0) {
                for (Map.Entry<String, List<URI>> entry : map.entrySet()) {
                    String string = entry.getKey();
                    List<URI> list = entry.getValue();
                    TagService tagService = this._tagServiceLocator.getTagService(string);
                    TagManager.AttachTagsResult[] attachTagsResultArray = tagService.attachTags(new ManagedObjectReference[]{managedObjectReference}, list.toArray(new URI[list.size()]));
                    List<Exception> list2 = this.extractErrors((DynamicData[])attachTagsResultArray);
                    if (n > 0 && TagMutationProvider.failedWithManagedObjectNotFound(list2)) {
                        hashMap.put(string, list);
                        continue;
                    }
                    arrayList.addAll(list2);
                }
                if (hashMap.size() == 0) break;
                map = hashMap;
                hashMap = new HashMap();
                Thread.sleep(5000L);
            }
            this.setErrors(operationResult, arrayList);
        }
        catch (Exception exception) {
            _logger.error((Object)"An error occurred while attaching tags", (Throwable)exception);
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    static boolean failedWithManagedObjectNotFound(List<Exception> list) {
        for (Exception exception : list) {
            if (!(exception instanceof ManagedObjectNotFound)) continue;
            return true;
        }
        return false;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, TagDetachSpec tagDetachSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            Util.checkNotNull(tagDetachSpec, "spec");
            Util.checkNotNull(tagDetachSpec.resources, "spec.resources");
            operationResult.entity = tagDetachSpec.resources[0];
            if (tagDetachSpec.resources.length > 1) {
                operationResult.effect = new OperationEffect();
                operationResult.effect.affectedEntites = Arrays.copyOfRange(tagDetachSpec.resources, 1, tagDetachSpec.resources.length);
            }
            Map<String, List<URI>> map = this.getObjectServerGuidToUriMap(tagDetachSpec.resources);
            ArrayList<Exception> arrayList = new ArrayList<Exception>();
            for (Map.Entry<String, List<URI>> entry : map.entrySet()) {
                String string = entry.getKey();
                List<URI> list = entry.getValue();
                TagService tagService = this._tagServiceLocator.getTagService(string);
                TagManager.DetachTagsResult[] detachTagsResultArray = tagService.detachTags(new ManagedObjectReference[]{managedObjectReference}, list.toArray(new URI[list.size()]));
                arrayList.addAll(this.extractErrors((DynamicData[])detachTagsResultArray));
            }
            this.setErrors(operationResult, arrayList);
        }
        catch (Exception exception) {
            _logger.error((Object)"An error occurred while detaching tags", (Throwable)exception);
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    public OperationResult remove(ManagedObjectReference managedObjectReference, TagCreateSpec tagCreateSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            Util.checkNotNull(managedObjectReference, "moRef");
            TagService tagService = this._tagServiceLocator.getTagService(null);
            tagService.deleteTag(managedObjectReference);
        }
        catch (Exception exception) {
            _logger.error((Object)"An error occurred while deleting a tag", (Throwable)exception);
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    private ManagedObjectReference createTag(TagService tagService, TagCreateSpec tagCreateSpec) throws InterruptedException, ExecutionException {
        TagInfoImpl tagInfoImpl = new TagInfoImpl();
        tagInfoImpl.setName(tagCreateSpec.tagName);
        tagInfoImpl.setDescription(tagCreateSpec.tagDescription);
        return tagService.createTag(tagCreateSpec.categoryMoRef, (TagInfo)tagInfoImpl);
    }

    private List<Exception> extractErrors(DynamicData[] dynamicDataArray) {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        if (dynamicDataArray == null) {
            return arrayList;
        }
        for (int i = 0; i < dynamicDataArray.length; ++i) {
            Exception exception = this.getError(dynamicDataArray[i]);
            if (exception == null) continue;
            arrayList.add(exception);
        }
        return arrayList;
    }

    private Exception getError(DynamicData dynamicData) {
        if (dynamicData instanceof TagManager.AttachTagsResult) {
            Exception exception = ((TagManager.AttachTagsResult)dynamicData).getError();
            if (exception instanceof InvalidTagAssociationFault) {
                MethodFault methodFault = new MethodFault();
                methodFault.setMessage(Util.getLocalizedString("error.unableToAttachTag"));
                exception = methodFault;
            }
            return exception;
        }
        if (dynamicData instanceof TagManager.DetachTagsResult) {
            return ((TagManager.DetachTagsResult)dynamicData).getError();
        }
        return null;
    }

    private void setErrors(OperationResult operationResult, List<Exception> list) {
        if (!list.isEmpty()) {
            Object object = list.size() == 1 ? list.get(0) : new CompositeException(list);
            operationResult.error = MixedUtil.getMethodFault((Throwable)object);
        }
    }

    private Map<String, List<URI>> getObjectServerGuidToUriMap(Object[] objectArray) throws Exception {
        HashMap<String, List<URI>> hashMap = new HashMap<String, List<URI>>();
        for (Object object : objectArray) {
            URI uRI = Util.toURI(object);
            String string = this._objRefService.getServerGuid(object);
            if (StringUtil.isNullOrEmpty((String)string)) {
                _logger.warn((Object)"Assigning tags to objects which are not managed object references is not supported.");
                string = "GLOBAL";
            }
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList());
            }
            List list = (List)hashMap.get(string);
            list.add(uRI);
        }
        return hashMap;
    }
}

