/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.authz.impl;

import com.vmware.cis.license.common.cache.Cache;
import com.vmware.cis.license.common.cache.impl.LruCacheImpl;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationException;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheAuthorizationManagerWrapperImpl
implements AuthorizationManager {
    private static final int CACHE_CAPACITY = 100;
    private final AuthorizationManager _authorizationManager;
    private final Cache<LicenseScope, Boolean> _scopeToLicensingAdminPrivilegeGrantedCache;
    private final Log _logger = LogFactory.getLog(CacheAuthorizationManagerWrapperImpl.class);

    public CacheAuthorizationManagerWrapperImpl(AuthorizationManager authorizationManager) {
        this._authorizationManager = authorizationManager;
        this._scopeToLicensingAdminPrivilegeGrantedCache = new LruCacheImpl(100);
    }

    @Override
    public boolean isLicensingAdminPrivilegeGranted(LicenseScope licenseScope) throws AuthorizationException {
        Boolean bl = (Boolean)this._scopeToLicensingAdminPrivilegeGrantedCache.get((Object)licenseScope);
        if (bl == null) {
            try {
                bl = this._authorizationManager.isLicensingAdminPrivilegeGranted(licenseScope);
                this._scopeToLicensingAdminPrivilegeGrantedCache.put((Object)licenseScope, (Object)bl);
            }
            catch (AuthorizationException authorizationException) {
                this._logger.warn((Object)("Cannot cache licensing admin privilege granted for scope: " + licenseScope + ";\nAuthorizationException occurred: "), (Throwable)authorizationException);
                throw authorizationException;
            }
        }
        return bl;
    }
}

