/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.cis.license.client.LicenseClientException;
import com.vmware.cis.license.client.LicenseClientFactory;
import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseClientUnavailableException;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.VpxLicenseServiceLocator;
import com.vmware.license.client.cis.ls.scope.ScopeResolver;
import com.vmware.license.client.cis.ls.scope.ScopeResolverException;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.debug.TimeMonitor;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import com.vmware.vise.vim.connections.SiteAffinityServerEndpointProvider;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseClientProviderImpl
implements LicenseClientProvider {
    private static final long LOGOUT_THRESHOLD_IN_NANOS = TimeUnit.SECONDS.toNanos(2L);
    private static final long CLOSE_THRESHOLD_IN_NANOS = TimeUnit.SECONDS.toNanos(2L);
    private final Log _logger = LogFactory.getLog(LicenseClientProviderImpl.class);
    private final LicenseClientFactory _licenseClientFactory;
    private final ScopeResolver _scopeResolver;
    private final VpxLicenseServiceLocator _vpxLicenseServiceLocator;
    private final SharedHttpConfigPool _sharedHttpConfigPool;
    private final LicenseClientFactory.LicenseClientAutomaticAuthenticator _licenseClientAuthenticator;
    private final Executor _logoutExecutor;

    public LicenseClientProviderImpl(LicenseClientFactory licenseClientFactory, ScopeResolver scopeResolver, VpxLicenseServiceLocator vpxLicenseServiceLocator, SharedHttpConfigPool sharedHttpConfigPool, LicenseClientFactory.LicenseClientAutomaticAuthenticator licenseClientAutomaticAuthenticator, Executor executor) {
        this._licenseClientFactory = licenseClientFactory;
        this._scopeResolver = scopeResolver;
        this._vpxLicenseServiceLocator = vpxLicenseServiceLocator;
        this._sharedHttpConfigPool = sharedHttpConfigPool;
        this._licenseClientAuthenticator = licenseClientAutomaticAuthenticator;
        this._logoutExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LicenseClient getLicenseClient(LicenseScope licenseScope) throws LicenseClientUnavailableException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseScope});
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = this.getClass().getClassLoader();
        LicenseClient licenseClient = null;
        try {
            Thread.currentThread().setContextClassLoader(classLoader2);
            try {
                licenseClient = this.buildLicenseClient(licenseScope);
            }
            catch (LicenseClientException licenseClientException) {
                throw new LicenseClientUnavailableException(licenseClientException, LicenseClientUnavailableException.Reason.CREATION_FAILED);
            }
            this._licenseClientAuthenticator.login(licenseClient);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return licenseClient;
    }

    @Override
    public void disposeLicenseClient(final LicenseClient licenseClient) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{licenseClient});
        this._logoutExecutor.execute(new Runnable(){

            @Override
            public void run() {
                LicenseClientProviderImpl.this.logoutLicenseClient(licenseClient);
                LicenseClientProviderImpl.this.closeLicenseClient(licenseClient);
            }
        });
    }

    private LicenseClient buildLicenseClient(LicenseScope licenseScope) throws LicenseClientUnavailableException {
        HttpConfiguration httpConfiguration = this._sharedHttpConfigPool.getHttpConfig(licenseScope.toString());
        URI uRI = this.getLsUri(licenseScope);
        LicenseClient licenseClient = null;
        boolean bl = this.shouldEnableSiteAffinity(licenseScope);
        licenseClient = bl ? this._licenseClientFactory.createClient((ServerEndpointProvider)new SiteAffinityServerEndpointProvider(uRI), httpConfiguration) : this._licenseClientFactory.createClient(uRI, httpConfiguration);
        return licenseClient;
    }

    private URI getLsUri(LicenseScope licenseScope) throws LicenseClientUnavailableException {
        URI uRI = null;
        try {
            String string = this._scopeResolver.getVcId(licenseScope);
            uRI = this._vpxLicenseServiceLocator.getLicenseServiceUriForVc(string);
        }
        catch (Exception exception) {
            throw new LicenseClientUnavailableException(exception, LicenseClientUnavailableException.Reason.LOCATION_UNAVAILABLE);
        }
        return uRI;
    }

    private boolean shouldEnableSiteAffinity(LicenseScope licenseScope) {
        try {
            return this._scopeResolver.isLocalVcScope(licenseScope);
        }
        catch (ScopeResolverException scopeResolverException) {
            this._logger.warn((Object)"Unable to determine if the scope is local. Assuming not and creating not PSC HA capable local LicenseClient: ", (Throwable)scopeResolverException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logoutLicenseClient(LicenseClient licenseClient) {
        TimeMonitor timeMonitor = new TimeMonitor();
        try {
            timeMonitor.init();
            licenseClient.logout();
        }
        catch (Exception exception) {
            this._logger.error((Object)("Failed to logout license client: " + licenseClient), (Throwable)exception);
        }
        finally {
            timeMonitor.logTimeIfExceeding(LOGOUT_THRESHOLD_IN_NANOS, "LicenseClient.logout", LicenseClient.class, (Object)licenseClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLicenseClient(LicenseClient licenseClient) {
        TimeMonitor timeMonitor = new TimeMonitor();
        try {
            timeMonitor.init();
            licenseClient.close();
        }
        catch (Exception exception) {
            this._logger.error((Object)("Failed to close license client: " + licenseClient), (Throwable)exception);
        }
        finally {
            timeMonitor.logTimeIfExceeding(CLOSE_THRESHOLD_IN_NANOS, "LicenseClient.close", LicenseClient.class, (Object)licenseClient);
        }
    }
}

