/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.license.client.cis.ls.LicenseServiceDiscoveryException;
import com.vmware.license.client.cis.ls.VpxLicenseServiceLocator;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VpxLicenseServiceLocatorImpl
implements VpxLicenseServiceLocator {
    private final Log _logger = LogFactory.getLog(VpxLicenseServiceLocatorImpl.class);

    @Override
    public URI getLicenseServiceUriForVc(String string) throws LicenseServiceDiscoveryException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        try {
            VcService vcService = VimSessionUtil.getService((String)string);
            if (vcService == null) {
                this._logger.warn((Object)("No VcService found in session for VC ID: " + string));
                String string2 = ManagementUtil.getLocalizedString("error.lsLocationUnavailable");
                throw new LicenseServiceDiscoveryException(string2);
            }
            ManagedObjectReference managedObjectReference = vcService.getServiceInstanceContent().getLicenseManager();
            LicenseManager licenseManager = (LicenseManager)vcService.getManagedObject(managedObjectReference);
            String string3 = licenseManager.getLicensedEdition();
            if (StringUtil.isNullOrEmpty((String)string3)) {
                this._logger.warn((Object)("Null or empty LS URL returned by VC with ID: " + string));
                String string4 = ManagementUtil.getLocalizedString("error.lsLocationUnavailable");
                throw new LicenseServiceDiscoveryException(string4);
            }
            URI uRI = URI.create(string3);
            return uRI;
        }
        catch (Exception exception) {
            this._logger.warn((Object)("Exception occurred while trying to create LS URI.\nVC ID: " + string), (Throwable)exception);
            String string5 = ManagementUtil.getLocalizedString("error.lsLocationUnavailable");
            throw new LicenseServiceDiscoveryException(string5);
        }
    }
}

