/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.topology.impl;

import com.vmware.license.client.cis.ls.topology.Folder;
import com.vmware.license.client.cis.ls.topology.LookupClient;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.util.debug.TimeMonitor;
import com.vmware.vise.vim.lookup.LookupService;
import java.util.concurrent.TimeUnit;

public class LookupClientImpl
implements LookupClient {
    private static final long LOOKUP_CALL_LOG_THRESHOLD_IN_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private final LookupService _lookupService;

    private static ServiceRegistration.Filter createFilter(ServiceRegistration.ServiceType serviceType, Folder folder) {
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setServiceType(serviceType);
        if (folder != null) {
            filter.setNodeId(folder.getNodeId());
            filter.setSiteId(folder.getSiteId());
        }
        return filter;
    }

    public LookupClientImpl(LookupService lookupService) {
        this._lookupService = lookupService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceRegistration.Info[] searchServiceInfos(ServiceRegistration.ServiceType serviceType, Folder folder) {
        ServiceRegistration.Filter filter = LookupClientImpl.createFilter(serviceType, folder);
        TimeMonitor timeMonitor = new TimeMonitor();
        try {
            timeMonitor.init();
            ServiceRegistration.Info[] infoArray = this._lookupService.getServiceRegistrationInfos(filter);
            return infoArray;
        }
        finally {
            timeMonitor.logTimeIfExceeding(LOOKUP_CALL_LOG_THRESHOLD_IN_NANOS, "NGC Lookup service search", LookupService.class, (Object)this._lookupService);
        }
    }
}

