/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.authz.AuthorizationException;
import com.vmware.license.client.cis.ls.authz.AuthorizationManager;
import com.vmware.license.client.cis.management.AssetUpdateLicenseSpec;
import com.vmware.license.client.cis.management.LicenseSearchProperties;
import com.vmware.license.client.cis.management.ManagementException;
import com.vmware.license.client.cis.management.ManagementObjectsFormatter;
import com.vmware.license.client.cis.management.VpxManagementEditor;
import com.vmware.license.client.cis.management.ds.Asset;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.AssignLicenseAggregatedUsages;
import com.vmware.license.client.cis.management.ds.AssignLicenseUnsupportedFeatures;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.LicenseAssignInfo;
import com.vmware.license.client.cis.management.ds.LicenseAssignRestriction;
import com.vmware.license.client.cis.management.ds.LicenseType;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.ds.results.AssetAssignLicenseValidationResult;
import com.vmware.license.client.cis.management.ds.results.AssetAssignSubscriptionLicenseValidationResult;
import com.vmware.license.client.cis.management.ds.specs.AssetAssignLicenseConnectInfoValidateSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetAssignLicenseSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetAssignLicenseValidateSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetAssignSubscriptionLicenseValidateSpec;
import com.vmware.license.client.cis.management.ds.specs.AssetRemoveSpec;
import com.vmware.license.client.cis.management.util.AssetUtil;
import com.vmware.license.client.cis.management.util.AssignLicenseUnsupportedFeaturesUtil;
import com.vmware.license.client.cis.management.util.AssignLicenseUsageCalculationUtil;
import com.vmware.license.client.cis.management.util.HostConnectionUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.client.cis.util.MutationUtil;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssetMutationProvider
implements MutationProvider {
    private static final String SOURCE_ID_KEY = "sourceId";
    private static final String SOURCE_ID_VC_VALUE = "vc";
    private final Log _logger = LogFactory.getLog(AssetMutationProvider.class);
    private final VpxManagementEditor _vpxManagementEditor;
    private final ManagementObjectsFormatter _managementObjectsFormatter;
    private final AuthorizationManager _authorizationManager;

    public AssetMutationProvider(VpxManagementEditor vpxManagementEditor, ManagementObjectsFormatter managementObjectsFormatter, AuthorizationManager authorizationManager) {
        this._vpxManagementEditor = vpxManagementEditor;
        this._managementObjectsFormatter = managementObjectsFormatter;
        this._authorizationManager = authorizationManager;
    }

    public OperationResult[] applyOnMultiEntity(URI[] uRIArray, AssetAssignLicenseSpec assetAssignLicenseSpec) {
        try {
            URI uRI = assetAssignLicenseSpec.licenseRef;
            UriUtil.validateLicenseUri(uRI);
            boolean bl = LicenseUtil.EVALUATION_LICENSE_URI.equals(uRI);
            AssetUpdateLicenseSpec[] assetUpdateLicenseSpecArray = this.createAssetUpdateLicenseSpecs(uRIArray, uRI, bl);
            this._vpxManagementEditor.updateAssetsLicense(assetUpdateLicenseSpecArray);
            return MutationUtil.createOperationResults(uRIArray);
        }
        catch (Exception exception) {
            this.logError(exception);
            return MutationUtil.createOperationResults(exception);
        }
    }

    public OperationResult[] removeOnMultiEntity(URI[] uRIArray, AssetRemoveSpec assetRemoveSpec) {
        try {
            this._vpxManagementEditor.unregisterAssets(uRIArray);
            return MutationUtil.createOperationResults(uRIArray);
        }
        catch (Exception exception) {
            this.logError(exception);
            return MutationUtil.createOperationResults(exception);
        }
    }

    public ValidationResult[] validateOnMultiEntity(URI[] uRIArray, AssetAssignSubscriptionLicenseValidateSpec assetAssignSubscriptionLicenseValidateSpec) {
        try {
            if (ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
                throw new IllegalArgumentException("The asset URIs array should not be empty");
            }
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(uRIArray[0]);
            Asset[] assetArray = this._vpxManagementEditor.getAssets(uRIArray, licenseScope);
            LicenseSearchProperties licenseSearchProperties = new LicenseSearchProperties();
            licenseSearchProperties.setLicenseType(LicenseType.SUBSCRIPTION);
            License[] licenseArray = this._vpxManagementEditor.getLicenses(licenseScope, licenseSearchProperties);
            this._managementObjectsFormatter.formatAssets(assetArray);
            this._managementObjectsFormatter.formatLicenses(licenseArray);
            AssetAssignSubscriptionLicenseValidationResult assetAssignSubscriptionLicenseValidationResult = new AssetAssignSubscriptionLicenseValidationResult();
            assetAssignSubscriptionLicenseValidationResult.assets = assetArray;
            assetAssignSubscriptionLicenseValidationResult.licenses = licenseArray;
            return MutationUtil.createValidationResults(new Object[]{assetAssignSubscriptionLicenseValidationResult});
        }
        catch (Exception exception) {
            this.logError(exception);
            return MutationUtil.createValidationResults(exception);
        }
    }

    public ValidationResult[] validateOnMultiEntity(Object[] objectArray, AssetAssignLicenseValidateSpec assetAssignLicenseValidateSpec) {
        try {
            Object[] objectArray2;
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                throw new IllegalArgumentException("The entities array should not be empty");
            }
            Asset[] assetArray = null;
            LicenseScope licenseScope = null;
            if (objectArray instanceof URI[]) {
                objectArray2 = (URI[])objectArray;
                licenseScope = LicenseScopeUtil.getLicenseScopeByUiObjectUri(objectArray2[0]);
                assetArray = this._vpxManagementEditor.getAssets((URI[])objectArray2, licenseScope);
            } else if (objectArray instanceof ManagedObjectReference[]) {
                objectArray2 = (ManagedObjectReference[])objectArray;
                if (!LicenseScopeUtil.doAssetsHaveSameScope((ManagedObjectReference[])objectArray2)) {
                    throw new IllegalArgumentException("The entities array should have the same license scope");
                }
                licenseScope = LicenseScopeUtil.getLicenseScopeByMoRef((ManagedObjectReference)objectArray2[0]);
                assetArray = this._vpxManagementEditor.getAssetsByMoRefs((ManagedObjectReference[])objectArray2, licenseScope);
            } else {
                throw new IllegalArgumentException("The entities array should be either a URI array or an array with a single ManagedObjectReference");
            }
            objectArray2 = this.getSkLicenses(licenseScope);
            return this.validateMultiAssetsAssignments(assetArray, (License[])objectArray2, assetAssignLicenseValidateSpec.initialLicensesRefs);
        }
        catch (Exception exception) {
            this.logError(exception);
            return MutationUtil.createValidationResults(exception);
        }
    }

    public ValidationResult validate(AssetAssignLicenseConnectInfoValidateSpec assetAssignLicenseConnectInfoValidateSpec) {
        try {
            License[] licenseArray;
            if (assetAssignLicenseConnectInfoValidateSpec.scope == null || assetAssignLicenseConnectInfoValidateSpec.connectInfo == null) {
                throw new IllegalArgumentException("Scope and connectInfo should not be empty");
            }
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(assetAssignLicenseConnectInfoValidateSpec.scope);
            boolean bl = false;
            try {
                bl = this._authorizationManager.isLicensingAdminPrivilegeGranted(licenseScope);
            }
            catch (AuthorizationException authorizationException) {
                this._logger.warn((Object)"Cannot retrieve privileges data: ", (Throwable)authorizationException);
            }
            if (bl) {
                try {
                    licenseArray = this.getSkLicenses(licenseScope);
                }
                catch (ManagementException managementException) {
                    if (ManagementException.ReasonType.NOT_AUTHORIZED.equals((Object)managementException.getReasonType())) {
                        this._logger.warn((Object)"No licensing privilege is granted. Continuing add host wizard with eval option only.");
                        licenseArray = new License[]{};
                    }
                    throw managementException;
                }
            } else {
                this._logger.warn((Object)"No licensing privilege is granted. Continuing add host wizard with eval option only.");
                licenseArray = new License[]{};
            }
            Asset asset = HostConnectionUtil.previewHostAsset(assetAssignLicenseConnectInfoValidateSpec.connectInfo, licenseArray);
            return this.validateAddHostAssignment(asset, licenseArray, assetAssignLicenseConnectInfoValidateSpec.initialLicensesRefs);
        }
        catch (Exception exception) {
            this.logError(exception);
            return MutationUtil.createValidationResult(exception);
        }
    }

    private void logError(Throwable throwable) {
        if (this._logger.isErrorEnabled()) {
            this._logger.error((Object)"Unable to execute asset mutation operation: ", throwable);
        }
    }

    private AssetUpdateLicenseSpec[] createAssetUpdateLicenseSpecs(URI[] uRIArray, URI uRI, boolean bl) {
        if (ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
            return new AssetUpdateLicenseSpec[0];
        }
        AssetUpdateLicenseSpec[] assetUpdateLicenseSpecArray = new AssetUpdateLicenseSpec[uRIArray.length];
        for (int i = 0; i < uRIArray.length; ++i) {
            assetUpdateLicenseSpecArray[i] = new AssetUpdateLicenseSpec(uRIArray[i], uRI, bl);
        }
        return assetUpdateLicenseSpecArray;
    }

    private License[] getSkLicenses(LicenseScope licenseScope) {
        LicenseSearchProperties licenseSearchProperties = new LicenseSearchProperties();
        licenseSearchProperties.setLicenseType(LicenseType.SERIAL_KEY);
        License[] licenseArray = this._vpxManagementEditor.getLicenses(licenseScope, licenseSearchProperties);
        return licenseArray;
    }

    private ValidationResult[] validateMultiAssetsAssignments(Asset[] assetArray, License[] licenseArray, URI[] uRIArray) {
        ValidationResult validationResult = this.createAssignLicenseValidationResult(assetArray, licenseArray, true, null, false, uRIArray);
        return new ValidationResult[]{validationResult};
    }

    private ValidationResult createAssignLicenseValidationResult(Asset[] assetArray, License[] licenseArray, boolean bl, URI uRI, boolean bl2, URI[] uRIArray) {
        LicenseAssignInfo[] licenseAssignInfoArray = this.getApplicableLicensesAssignInfos(assetArray, licenseArray, bl, bl2);
        License[] licenseArray2 = this.getLicensesFromLicenseAssignInfos(licenseAssignInfoArray);
        AssignLicenseAggregatedUsages assignLicenseAggregatedUsages = AssignLicenseUsageCalculationUtil.createAssignLicenseAggregatedUsages(assetArray, licenseArray2);
        AssignLicenseUnsupportedFeatures assignLicenseUnsupportedFeatures = AssignLicenseUnsupportedFeaturesUtil.createAssignLicenseUnsupportedFeatures(assetArray, licenseArray2);
        this._managementObjectsFormatter.formatLicenses(licenseArray2);
        this._managementObjectsFormatter.formatAssets(assetArray);
        AssetAssignLicenseValidationResult assetAssignLicenseValidationResult = this.createAssetAssignLicenseValidationResult(assetArray, licenseAssignInfoArray, assignLicenseAggregatedUsages, assignLicenseUnsupportedFeatures, bl, uRI, uRIArray);
        return MutationUtil.createValidationResult((Object)assetAssignLicenseValidationResult);
    }

    private LicenseAssignInfo[] getApplicableLicensesAssignInfos(Asset[] assetArray, License[] licenseArray, boolean bl, boolean bl2) {
        ArrayList<LicenseAssignInfo> arrayList = new ArrayList<LicenseAssignInfo>();
        LicenseAssignInfo licenseAssignInfo = this.createEvaluationLicenseAssignInfo(assetArray);
        if (licenseAssignInfo != null) {
            arrayList.add(licenseAssignInfo);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])licenseArray)) {
            for (License license : licenseArray) {
                if (!AssetUtil.isLicenseApplicableForAssets(license, assetArray, bl)) continue;
                Set<LicenseAssignRestriction> set = AssetUtil.getLicenseAssignRestrictionsForAssets(license, assetArray);
                if (bl2 && LicenseUtil.isEmbeddedOemLicense(license)) {
                    set.add(LicenseAssignRestriction.EmbeddedOemLicense);
                }
                LicenseAssignInfo licenseAssignInfo2 = this.createLicenseAssignInfo(license, set, false);
                arrayList.add(licenseAssignInfo2);
            }
        }
        return arrayList.toArray(new LicenseAssignInfo[arrayList.size()]);
    }

    private LicenseAssignInfo createEvaluationLicenseAssignInfo(Asset[] assetArray) {
        HashSet<LicenseAssignRestriction> hashSet = new HashSet<LicenseAssignRestriction>();
        boolean bl = true;
        boolean bl2 = false;
        Long l = assetArray[0].getEvaluationLicense() == null ? null : assetArray[0].getEvaluationLicense().getExpirationTime();
        for (Asset asset : assetArray) {
            License license = asset.getEvaluationLicense();
            if (license == null) {
                bl = false;
                break;
            }
            Set<LicenseAssignRestriction> set = AssetUtil.getLicenseAssignRestrictionsForAsset(license, asset);
            hashSet.addAll(set);
            Long l2 = license.getExpirationTime();
            if (bl2 || ObjectUtil.compare((Comparable)l, (Comparable)l2) == 0) continue;
            bl2 = true;
            l = null;
        }
        if (!bl) {
            return null;
        }
        License license = LicenseUtil.createEvaluationLicense(l);
        return this.createLicenseAssignInfo(license, hashSet, bl2);
    }

    private LicenseAssignInfo createLicenseAssignInfo(License license, Set<LicenseAssignRestriction> set, boolean bl) {
        LicenseAssignInfo licenseAssignInfo = new LicenseAssignInfo();
        licenseAssignInfo.setLicense(license);
        licenseAssignInfo.setExpirationTimeMixed(bl);
        licenseAssignInfo.setAssignRestrictions(set.toArray(new LicenseAssignRestriction[set.size()]));
        return licenseAssignInfo;
    }

    private License[] getLicensesFromLicenseAssignInfos(LicenseAssignInfo[] licenseAssignInfoArray) {
        License[] licenseArray = new License[licenseAssignInfoArray.length];
        for (int i = 0; i < licenseAssignInfoArray.length; ++i) {
            licenseArray[i] = licenseAssignInfoArray[i].getLicense();
        }
        return licenseArray;
    }

    private AssetAssignLicenseValidationResult createAssetAssignLicenseValidationResult(Asset[] assetArray, LicenseAssignInfo[] licenseAssignInfoArray, AssignLicenseAggregatedUsages assignLicenseAggregatedUsages, AssignLicenseUnsupportedFeatures assignLicenseUnsupportedFeatures, boolean bl, URI uRI, URI[] uRIArray) {
        AssetAssignLicenseValidationResult assetAssignLicenseValidationResult = new AssetAssignLicenseValidationResult();
        this.initializeAssetProperties(assetAssignLicenseValidationResult, assetArray, licenseAssignInfoArray, bl);
        this.initializeLicenseProperties(assetAssignLicenseValidationResult, licenseAssignInfoArray, assignLicenseAggregatedUsages, assignLicenseUnsupportedFeatures, uRI, uRIArray);
        return assetAssignLicenseValidationResult;
    }

    private void initializeAssetProperties(AssetAssignLicenseValidationResult assetAssignLicenseValidationResult, Asset[] assetArray, LicenseAssignInfo[] licenseAssignInfoArray, boolean bl) {
        assetAssignLicenseValidationResult.assets = assetArray;
        assetAssignLicenseValidationResult.assetRefToName = this.buildAssetRefToNameMap(assetArray);
        assetAssignLicenseValidationResult.isAssetDlfVersionSupported = bl;
        Asset asset = assetArray[0];
        AssetLicenseState assetLicenseState = asset.getLicenseState();
        URI uRI = asset.getLicense() == null ? null : asset.getLicense().getUri();
        int n = 0;
        for (Asset asset2 : assetArray) {
            URI uRI2;
            if (assetLicenseState != asset2.getLicenseState()) {
                assetLicenseState = null;
            }
            URI uRI3 = uRI2 = asset2.getLicense() == null ? null : asset2.getLicense().getUri();
            if (uRI != null && !uRI.equals(uRI2)) {
                uRI = null;
            }
            if (!LicenseUtil.isEmbeddedOemLicense(asset2.getLicense())) continue;
            ++n;
        }
        assetAssignLicenseValidationResult.assetsCommonLicenseState = assetLicenseState;
        if (AssetLicenseState.EVALUATION.equals((Object)assetLicenseState)) {
            LicenseAssignInfo licenseAssignInfo = this.getEvaluationLicenseAssignInfo(licenseAssignInfoArray);
            assetAssignLicenseValidationResult.assetsCommonLicenseRef = licenseAssignInfo.getLicense().getUri();
        } else {
            assetAssignLicenseValidationResult.assetsCommonLicenseRef = uRI;
        }
        assetAssignLicenseValidationResult.embeddedOemLicensedAssetsCount = n;
    }

    private void initializeLicenseProperties(AssetAssignLicenseValidationResult assetAssignLicenseValidationResult, LicenseAssignInfo[] licenseAssignInfoArray, AssignLicenseAggregatedUsages assignLicenseAggregatedUsages, AssignLicenseUnsupportedFeatures assignLicenseUnsupportedFeatures, URI uRI, URI[] uRIArray) {
        this.updateLicensesAssignRestrictions(assetAssignLicenseValidationResult, licenseAssignInfoArray);
        assetAssignLicenseValidationResult.aggregatedUsages = assignLicenseAggregatedUsages;
        assetAssignLicenseValidationResult.unsupportedFeatures = assignLicenseUnsupportedFeatures;
        assetAssignLicenseValidationResult.licenseFromAnotherVcRef = uRI;
        LicenseAssignInfo licenseAssignInfo = this.getEvaluationLicenseAssignInfo(licenseAssignInfoArray);
        if (licenseAssignInfo != null) {
            assetAssignLicenseValidationResult.isEvaluationExpirationTimeMixed = licenseAssignInfo.isExpirationTimeMixed();
        }
        LicensesAssignInfosData licensesAssignInfosData = new LicensesAssignInfosData(licenseAssignInfoArray, uRIArray, assetAssignLicenseValidationResult.assetsCommonLicenseRef);
        assetAssignLicenseValidationResult.licensesAssignInfos = licensesAssignInfosData.getSortedLicensesAssignInfos();
        assetAssignLicenseValidationResult.newLicensesRefs = licensesAssignInfosData._newLicensesRefs;
        assetAssignLicenseValidationResult.areAllLicensesUnassignable = licensesAssignInfosData.areAllLicensesUnassignable();
    }

    private Map<URI, String> buildAssetRefToNameMap(Asset[] assetArray) {
        HashMap<URI, String> hashMap = new HashMap<URI, String>();
        for (Asset asset : assetArray) {
            hashMap.put(asset.getUri(), asset.getName());
        }
        return hashMap;
    }

    private LicenseAssignInfo getEvaluationLicenseAssignInfo(LicenseAssignInfo[] licenseAssignInfoArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseAssignInfoArray)) {
            return null;
        }
        LicenseAssignInfo licenseAssignInfo = licenseAssignInfoArray[0];
        if (licenseAssignInfo.getLicense().getIsEvaluation()) {
            return licenseAssignInfo;
        }
        return null;
    }

    private void updateLicensesAssignRestrictions(AssetAssignLicenseValidationResult assetAssignLicenseValidationResult, LicenseAssignInfo[] licenseAssignInfoArray) {
        for (LicenseAssignInfo licenseAssignInfo : licenseAssignInfoArray) {
            URI uRI = licenseAssignInfo.getLicense().getUri();
            if (!uRI.equals(assetAssignLicenseValidationResult.assetsCommonLicenseRef)) continue;
            licenseAssignInfo.setAssignRestrictions(null);
        }
    }

    private ValidationResult validateAddHostAssignment(Asset asset, License[] licenseArray, URI[] uRIArray) {
        License license;
        boolean bl = this.isHostDlfVersionSupported(asset, licenseArray);
        URI uRI = null;
        if (AssetLicenseState.LICENSED.equals((Object)asset.getLicenseState()) && !this.isHostLicensePresent(license = asset.getLicense(), licenseArray)) {
            licenseArray = (License[])ArrayUtil.append((Object[])licenseArray, (Object)((Object)license));
            uRI = this.isHostAssetLicensedInAnotherVc(asset) ? license.getUri() : null;
        }
        return this.createAssignLicenseValidationResult(new Asset[]{asset}, licenseArray, bl, uRI, true, uRIArray);
    }

    private boolean isHostDlfVersionSupported(Asset asset, License[] licenseArray) {
        for (License license : licenseArray) {
            if (!AssetUtil.isLicenseApplicableForAsset(license, asset, true)) continue;
            return true;
        }
        return false;
    }

    private boolean isHostLicensePresent(License license, License[] licenseArray) {
        String string = license.getSerialKeys()[0];
        for (License license2 : licenseArray) {
            if (!LicenseUtil.hasSerialKey(string, license2)) continue;
            return true;
        }
        return false;
    }

    private boolean isHostAssetLicensedInAnotherVc(Asset asset) {
        ProductCapability productCapability = AssetUtil.getAssetProductCapability(asset);
        if (productCapability == null) {
            throw new IllegalArgumentException("No capability found for host: " + asset.getName());
        }
        KeyAnyValue[] keyAnyValueArray = productCapability.getProperties();
        String string = (String)ManagementUtil.getKeyAnyValuePropertyValue(SOURCE_ID_KEY, keyAnyValueArray);
        return SOURCE_ID_VC_VALUE.equals(string);
    }

    private class LicensesAssignInfosData {
        private Set<URI> _newLicensesRefs = new HashSet<URI>();
        private URI _assetsCommonLicenseRef;
        private List<LicenseAssignInfo> _assignableLicensesAssignInfos = new ArrayList<LicenseAssignInfo>();
        private List<LicenseAssignInfo> _unassignableLicensesAssignInfos = new ArrayList<LicenseAssignInfo>();

        public LicensesAssignInfosData(LicenseAssignInfo[] licenseAssignInfoArray, URI[] uRIArray, URI uRI) {
            HashSet<URI> hashSet = new HashSet<URI>();
            ArrayList<LicenseAssignInfo> arrayList = new ArrayList<LicenseAssignInfo>();
            ArrayList<LicenseAssignInfo> arrayList2 = new ArrayList<LicenseAssignInfo>();
            LicenseAssignInfo[] licenseAssignInfoArray2 = licenseAssignInfoArray;
            int n = licenseAssignInfoArray2.length;
            for (int i = 0; i < n; ++i) {
                LicenseAssignInfo licenseAssignInfo;
                URI uRI2;
                HashSet<Object> hashSet2 = uRIArray == null ? new HashSet() : new HashSet<URI>(Arrays.asList(uRIArray));
                if (!hashSet2.contains(uRI2 = (licenseAssignInfo = licenseAssignInfoArray2[i]).getLicense().getUri())) {
                    hashSet.add(uRI2);
                }
                if (this.isAssignable(licenseAssignInfo)) {
                    arrayList.add(licenseAssignInfo);
                    continue;
                }
                arrayList2.add(licenseAssignInfo);
            }
            this._assetsCommonLicenseRef = uRI;
            this._newLicensesRefs = hashSet;
            this._assignableLicensesAssignInfos = arrayList;
            this._unassignableLicensesAssignInfos = arrayList2;
        }

        private boolean isAssignable(LicenseAssignInfo licenseAssignInfo) {
            if (licenseAssignInfo == null) {
                return false;
            }
            LicenseAssignRestriction[] licenseAssignRestrictionArray = licenseAssignInfo.getAssignRestrictions();
            return ArrayUtil.isNullOrEmpty((Object[])licenseAssignRestrictionArray);
        }

        public LicenseAssignInfo[] getSortedLicensesAssignInfos() {
            ArrayList<LicenseAssignInfo> arrayList = new ArrayList<LicenseAssignInfo>();
            List<LicenseAssignInfo> list = this.getSortedAssignableLicenseAssignInfos();
            arrayList.addAll(list);
            arrayList.addAll(this._unassignableLicensesAssignInfos);
            return arrayList.toArray(new LicenseAssignInfo[arrayList.size()]);
        }

        public boolean areAllLicensesUnassignable() {
            return ArrayUtil.isNullOrEmpty(this._assignableLicensesAssignInfos);
        }

        private List<LicenseAssignInfo> getSortedAssignableLicenseAssignInfos() {
            LicenseAssignInfo licenseAssignInfo = null;
            ArrayList<LicenseAssignInfo> arrayList = new ArrayList<LicenseAssignInfo>();
            ArrayList<LicenseAssignInfo> arrayList2 = new ArrayList<LicenseAssignInfo>();
            ArrayList<LicenseAssignInfo> arrayList3 = new ArrayList<LicenseAssignInfo>();
            LicenseAssignInfo licenseAssignInfo2 = null;
            for (LicenseAssignInfo licenseAssignInfo3 : this._assignableLicensesAssignInfos) {
                URI uRI = licenseAssignInfo3.getLicense().getUri();
                if (uRI.equals(this._assetsCommonLicenseRef)) {
                    licenseAssignInfo = licenseAssignInfo3;
                    continue;
                }
                if (this.isNewLicense(licenseAssignInfo3)) {
                    arrayList.add(licenseAssignInfo3);
                    continue;
                }
                if (this.isEvaluationLicense(licenseAssignInfo3)) {
                    licenseAssignInfo2 = licenseAssignInfo3;
                    continue;
                }
                if (this.isAssignedLicense(licenseAssignInfo3)) {
                    arrayList3.add(licenseAssignInfo3);
                    continue;
                }
                arrayList2.add(licenseAssignInfo3);
            }
            ArrayList arrayList4 = new ArrayList();
            arrayList4.addAll(arrayList);
            this.addIfNotNull(arrayList4, licenseAssignInfo);
            arrayList4.addAll(arrayList2);
            arrayList4.addAll(arrayList3);
            this.addIfNotNull(arrayList4, licenseAssignInfo2);
            return arrayList4;
        }

        private boolean isNewLicense(LicenseAssignInfo licenseAssignInfo) {
            URI uRI = licenseAssignInfo.getLicense().getUri();
            return this._newLicensesRefs.contains(uRI);
        }

        private boolean isEvaluationLicense(LicenseAssignInfo licenseAssignInfo) {
            return licenseAssignInfo.getLicense().getIsEvaluation();
        }

        private boolean isAssignedLicense(LicenseAssignInfo licenseAssignInfo) {
            return licenseAssignInfo.getLicense().isAssigned();
        }

        private void addIfNotNull(List<LicenseAssignInfo> list, LicenseAssignInfo licenseAssignInfo) {
            if (licenseAssignInfo != null) {
                list.add(licenseAssignInfo);
            }
        }
    }
}

