/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.ds.LicenseUiScope;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.LicenseSearchProperties;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.adapter.BaseManagementDataProviderAdapterImpl;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.adapter.LicensePropertyProviderBean;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.LicenseType;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.type;
import java.net.URI;

@type(value="License")
public class LicenseDataProviderAdapterImpl
extends BaseManagementDataProviderAdapterImpl<License> {
    private static final String RELATION_LICENSES = "licenses";
    private static final String PROPERTY_NAME_LICENSE_TYPE = "licenseType";
    private static final String PROPERTY_NAME_LICENSE_ASSIGNED = "licenseAssigned";
    private final ManagementEditor _managementEditor;

    private static boolean canHandleRelation(Object[] objectArray, String string) {
        return RELATION_LICENSES.equals(string) && UriUtil.containsSingleUriWithType(objectArray, "Product");
    }

    private static URI getProductUri(Object[] objectArray) {
        return (URI)objectArray[0];
    }

    public LicenseDataProviderAdapterImpl(ManagementEditor managementEditor) {
        this._managementEditor = managementEditor;
    }

    @Override
    protected BasePropertyProviderBean<License> getPropertyProvider() {
        return new LicensePropertyProviderBean();
    }

    @Override
    protected String getProvidedType() {
        return "License";
    }

    @Override
    protected URI getUri(License license) {
        return license.getUri();
    }

    protected License[] getObjectsByScope(LicenseScope licenseScope) {
        return this._managementEditor.getLicenses(licenseScope, null);
    }

    protected License[] getObjectsByCompositeConstraint(CompositeConstraint compositeConstraint) {
        if (compositeConstraint.nestedConstraints.length > 1 && !Conjoiner.AND.equals((Object)compositeConstraint.conjoiner)) {
            return (License[])super.getObjectsByCompositeConstraint(compositeConstraint);
        }
        LicenseConstraintProperties licenseConstraintProperties = this.getConstraintProperties(compositeConstraint.nestedConstraints);
        LicenseSearchProperties licenseSearchProperties = new LicenseSearchProperties();
        licenseSearchProperties.setLicenseType(licenseConstraintProperties.licenseType);
        licenseSearchProperties.setLicenseAssigned(licenseConstraintProperties.licenseAssigned);
        License[] licenseArray = null;
        if (licenseConstraintProperties.licenseUiScope != null) {
            LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByUiScope(licenseConstraintProperties.licenseUiScope);
            licenseArray = this._managementEditor.getLicenses(licenseScope, licenseSearchProperties);
        } else {
            licenseArray = licenseConstraintProperties.productUri != null ? this._managementEditor.getLicensesForProduct(licenseConstraintProperties.productUri, licenseSearchProperties) : (License[])super.getObjectsByCompositeConstraint(compositeConstraint);
        }
        return licenseArray;
    }

    protected License[] getObjectsByUrisAndScope(URI[] uRIArray, LicenseScope licenseScope) {
        return this._managementEditor.getLicenses(uRIArray, licenseScope);
    }

    protected License[] getRelatedObjects(Object[] objectArray, String string) {
        if (!LicenseDataProviderAdapterImpl.canHandleRelation(objectArray, string)) {
            return (License[])super.getRelatedObjects(objectArray, string);
        }
        URI uRI = LicenseDataProviderAdapterImpl.getProductUri(objectArray);
        return this._managementEditor.getLicensesForProduct(uRI, null);
    }

    private LicenseConstraintProperties getConstraintProperties(Constraint[] constraintArray) {
        LicenseConstraintProperties licenseConstraintProperties = new LicenseConstraintProperties();
        for (Constraint constraint : constraintArray) {
            PropertyConstraint propertyConstraint;
            if (constraint instanceof PropertyConstraint) {
                propertyConstraint = (PropertyConstraint)constraint;
                this.updateLicenseConstraintProperties(licenseConstraintProperties, propertyConstraint);
                continue;
            }
            if (!(constraint instanceof RelationalConstraint)) continue;
            propertyConstraint = (RelationalConstraint)constraint;
            this.updateLicenseConstraintProperties(licenseConstraintProperties, (RelationalConstraint)propertyConstraint);
        }
        return licenseConstraintProperties;
    }

    private void updateLicenseConstraintProperties(LicenseConstraintProperties licenseConstraintProperties, PropertyConstraint propertyConstraint) {
        if ("scope".equals(propertyConstraint.propertyName)) {
            if (propertyConstraint.comparableValue instanceof String) {
                licenseConstraintProperties.licenseUiScope = new LicenseUiScope();
                licenseConstraintProperties.licenseUiScope.setId((String)propertyConstraint.comparableValue);
            } else {
                licenseConstraintProperties.licenseUiScope = (LicenseUiScope)((Object)propertyConstraint.comparableValue);
            }
        } else if (PROPERTY_NAME_LICENSE_TYPE.equals(propertyConstraint.propertyName)) {
            licenseConstraintProperties.licenseType = propertyConstraint.comparableValue instanceof String ? LicenseType.valueOf((String)propertyConstraint.comparableValue) : (LicenseType)((Object)propertyConstraint.comparableValue);
        } else if (PROPERTY_NAME_LICENSE_ASSIGNED.equals(propertyConstraint.propertyName)) {
            licenseConstraintProperties.licenseAssigned = (Boolean)propertyConstraint.comparableValue;
        }
    }

    private void updateLicenseConstraintProperties(LicenseConstraintProperties licenseConstraintProperties, RelationalConstraint relationalConstraint) {
        Object[] objectArray = Utils.getEnumeratedObjects((RelationalConstraint)relationalConstraint);
        if (!LicenseDataProviderAdapterImpl.canHandleRelation(objectArray, relationalConstraint.relation)) {
            return;
        }
        licenseConstraintProperties.productUri = LicenseDataProviderAdapterImpl.getProductUri(objectArray);
    }

    private static class LicenseConstraintProperties {
        public LicenseUiScope licenseUiScope;
        public LicenseType licenseType;
        public Boolean licenseAssigned;
        public URI productUri;

        private LicenseConstraintProperties() {
        }
    }
}

