/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;

public class LicensePropertyProviderBean
extends BasePropertyProviderBean<License> {
    @type(value="License")
    public License getLicense(URI uRI) {
        License license = (License)((Object)this.getDataObject(uRI));
        return license;
    }

    @type(value="License")
    public String getName(URI uRI) {
        License license = (License)((Object)this.getDataObject(uRI));
        return license.getName();
    }

    @type(value="License")
    public boolean getIsRemovable(URI uRI) {
        License license = (License)((Object)this.getDataObject(uRI));
        return !license.isAssigned();
    }

    @type(value="License")
    public boolean getIsAssignableToVcs(URI uRI) {
        return this.isAssignableToAssetsOfType(uRI, AssetType.VC);
    }

    @type(value="License")
    public boolean getIsAssignableToHosts(URI uRI) {
        return this.isAssignableToAssetsOfType(uRI, AssetType.HOST);
    }

    @type(value="License")
    public boolean getIsAssignableToClusters(URI uRI) {
        return this.isAssignableToAssetsOfType(uRI, AssetType.CLUSTER);
    }

    @type(value="License")
    public boolean getIsAssignableToSolutions(URI uRI) {
        return this.isAssignableToAssetsOfType(uRI, AssetType.SOLUTION);
    }

    @type(value="License")
    public boolean getIsMyVMwareLicense(URI uRI) {
        License license = (License)((Object)this.getDataObject(uRI));
        return license.getMyVMwareInfo() != null;
    }

    @type(value="License")
    public KeyValue[] getPhoneHomeCollectorProperties(URI uRI) {
        Object object;
        ProductRestriction[] productRestrictionArray;
        License license = (License)((Object)this.getDataObject(uRI));
        Object object2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object[] objectArray = license.getSerialKeys();
        if (!ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            object2 = objectArray[0];
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])(productRestrictionArray = license.getProductRestrictions())) && (object = productRestrictionArray[0]) != null) {
            CostUnit costUnit;
            Product product = ((ProductRestriction)((Object)object)).getProduct();
            string = product.getFormattedName();
            CostUnit[] costUnitArray = product.getCostUnits();
            if (!ArrayUtil.isNullOrEmpty((Object[])costUnitArray) && (costUnit = costUnitArray[0]) != null) {
                string2 = costUnit.getId();
                if (costUnit.getUsage() != null) {
                    string3 = costUnit.getUsage().toString();
                }
                if (costUnit.getLimit() != null) {
                    string4 = costUnit.getLimit().toString();
                }
            }
        }
        object = new KeyValue[]{new KeyValue("serialKey", (String)object2), new KeyValue("productDisplayName", string), new KeyValue("costUnitId", string2), new KeyValue("costUnitUsage", string3), new KeyValue("costUnitLimit", string4)};
        return object;
    }

    private boolean isAssignableToAssetsOfType(URI uRI, AssetType assetType) {
        ProductRestriction[] productRestrictionArray;
        License license = (License)((Object)this.getDataObject(uRI));
        for (ProductRestriction productRestriction : productRestrictionArray = license.getProductRestrictions()) {
            if (!assetType.equals((Object)productRestriction.getProduct().getAssetsType())) continue;
            return true;
        }
        return false;
    }
}

