/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.impl;

import com.vmware.license.client.cis.ds.LimitEnforcementType;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.util.MathUtil;
import com.vmware.vim.binding.cis.license.CostUnitLimit;
import com.vmware.vim.binding.cis.license.CostUnitUsage;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vise.util.ArrayUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class CostUnitFactory {
    public static CostUnitFactory INSTANCE = new CostUnitFactory();

    public CostUnit[] createCostUnits(CostUnitUsage[] costUnitUsageArray, CostUnitLimit[] costUnitLimitArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitUsageArray) && ArrayUtil.isNullOrEmpty((Object[])costUnitLimitArray)) {
            return new CostUnit[0];
        }
        Map<String, CostUnitUsage> map = this.createIdToUsageMap(costUnitUsageArray);
        Map<String, CostUnitLimit> map2 = this.createIdToLimitMap(costUnitLimitArray);
        return this.createCostUnits(map, map2);
    }

    public CostUnit createCostUnit(CostUnitUsage costUnitUsage, CostUnitLimit costUnitLimit) {
        if (costUnitUsage == null && costUnitLimit == null) {
            return null;
        }
        String string = costUnitUsage == null ? costUnitLimit.getUnit().getId() : costUnitUsage.getUnit().getId();
        Long l = costUnitUsage != null ? Long.valueOf(costUnitUsage.getValue()) : null;
        Long l2 = costUnitLimit != null ? Long.valueOf(costUnitLimit.getValue()) : null;
        LimitEnforcementType limitEnforcementType = costUnitLimit != null ? this.getLimitEnforcementType(costUnitLimit.getEnforcementType()) : null;
        return this.createCostUnit(string, l, l2, limitEnforcementType);
    }

    public CostUnit createCostUnit(LicenseManager.LicenseInfo licenseInfo) {
        if (licenseInfo == null) {
            return null;
        }
        return this.createCostUnit(licenseInfo.getCostUnit(), licenseInfo.getUsed(), licenseInfo.getTotal(), LimitEnforcementType.HARD_ENFORCED);
    }

    public CostUnit createCostUnit(String string, Number number, Number number2, LimitEnforcementType limitEnforcementType) {
        CostUnit costUnit = new CostUnit();
        costUnit.setId(string);
        Double d = number != null ? Double.valueOf(number.doubleValue()) : null;
        costUnit.setUsage(d);
        Double d2 = number2 != null ? Double.valueOf(number2.doubleValue()) : null;
        costUnit.setLimit(d2);
        costUnit.setLimitEnforcementType(limitEnforcementType);
        Double d3 = MathUtil.calculatePercentage(d, d2);
        costUnit.setUsagePercentage(d3);
        return costUnit;
    }

    private Map<String, CostUnitUsage> createIdToUsageMap(CostUnitUsage[] costUnitUsageArray) {
        LinkedHashMap<String, CostUnitUsage> linkedHashMap = new LinkedHashMap<String, CostUnitUsage>();
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitUsageArray)) {
            return linkedHashMap;
        }
        for (CostUnitUsage costUnitUsage : costUnitUsageArray) {
            linkedHashMap.put(costUnitUsage.getUnit().getId(), costUnitUsage);
        }
        return linkedHashMap;
    }

    private Map<String, CostUnitLimit> createIdToLimitMap(CostUnitLimit[] costUnitLimitArray) {
        LinkedHashMap<String, CostUnitLimit> linkedHashMap = new LinkedHashMap<String, CostUnitLimit>();
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitLimitArray)) {
            return linkedHashMap;
        }
        for (CostUnitLimit costUnitLimit : costUnitLimitArray) {
            linkedHashMap.put(costUnitLimit.getUnit().getId(), costUnitLimit);
        }
        return linkedHashMap;
    }

    private CostUnit[] createCostUnits(Map<String, CostUnitUsage> map, Map<String, CostUnitLimit> map2) {
        CostUnitLimit costUnitLimit;
        String string;
        ArrayList<CostUnit> arrayList = new ArrayList<CostUnit>();
        for (Map.Entry<String, CostUnitUsage> entry : map.entrySet()) {
            string = entry.getKey();
            costUnitLimit = map2.remove(string);
            arrayList.add(this.createCostUnit(entry.getValue(), costUnitLimit));
        }
        for (Map.Entry<String, CostUnitUsage> entry : map2.entrySet()) {
            string = entry.getKey();
            costUnitLimit = map.get(string);
            arrayList.add(this.createCostUnit((CostUnitUsage)costUnitLimit, (CostUnitLimit)entry.getValue()));
        }
        return arrayList.toArray(new CostUnit[arrayList.size()]);
    }

    private LimitEnforcementType getLimitEnforcementType(String string) {
        LimitEnforcementType limitEnforcementType = null;
        if (com.vmware.vim.binding.cis.license.LimitEnforcementType.notEnforced.name().equals(string)) {
            limitEnforcementType = LimitEnforcementType.NOT_ENFORCED;
        } else if (com.vmware.vim.binding.cis.license.LimitEnforcementType.softEnforced.name().equals(string)) {
            limitEnforcementType = LimitEnforcementType.SOFT_ENFORCED;
        } else if (com.vmware.vim.binding.cis.license.LimitEnforcementType.hardEnforced.name().equals(string)) {
            limitEnforcementType = LimitEnforcementType.HARD_ENFORCED;
        }
        return limitEnforcementType;
    }
}

