/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetSearchProperties;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ds.AssetLicenseState;
import com.vmware.license.client.cis.management.ds.LicenseAssignRestriction;
import com.vmware.license.client.cis.management.ds.ProductCapability;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.license.client.cis.management.util.FeatureUtil;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.management.util.SubscriptionLicensingUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vim.binding.cis.license.Asset;
import com.vmware.vim.binding.cis.license.AssetInfo;
import com.vmware.vim.binding.cis.license.License;
import com.vmware.vim.binding.cis.license.ProductFamily;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class AssetUtil {
    public static com.vmware.license.client.cis.management.ds.Asset createAsset(Asset asset, LicenseScope licenseScope) {
        if (asset == null) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.Asset asset2 = new com.vmware.license.client.cis.management.ds.Asset();
        URI uRI = UriUtil.buildAssetUri(asset.getId(), licenseScope);
        asset2.setUri(uRI);
        AssetUtil.populateAssetInfo(asset2, asset.getInfo(), licenseScope);
        return asset2;
    }

    public static boolean isAssetOfType(com.vmware.license.client.cis.management.ds.Asset asset, AssetType assetType) {
        if (asset == null || assetType == null) {
            return false;
        }
        return assetType.equals((Object)asset.getType());
    }

    public static AssetLicenseState getAssetLicenseState(com.vmware.license.client.cis.management.ds.License license) {
        if (license == null) {
            return AssetLicenseState.UNLICENSED;
        }
        if (license.getIsEvaluation()) {
            return AssetLicenseState.EVALUATION;
        }
        return AssetLicenseState.LICENSED;
    }

    public static boolean isLicenseApplicableForAssets(com.vmware.license.client.cis.management.ds.License license, com.vmware.license.client.cis.management.ds.Asset[] assetArray, boolean bl) {
        if (SubscriptionLicensingUtil.isSubscriptionLicense(license)) {
            return true;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])license.getProductRestrictions())) {
            return false;
        }
        for (com.vmware.license.client.cis.management.ds.Asset asset : assetArray) {
            if (AssetUtil.isLicenseApplicableForAsset(license, asset, bl)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLicenseApplicableForAsset(com.vmware.license.client.cis.management.ds.License license, com.vmware.license.client.cis.management.ds.Asset asset, boolean bl) {
        ProductRestriction productRestriction = AssetUtil.getAssetProductRestrictionFromLicense(asset, license);
        if (productRestriction == null) {
            return false;
        }
        if (asset.getVersion() == null) {
            return true;
        }
        if (!bl) {
            return true;
        }
        ProductCapability productCapability = AssetUtil.getAssetProductCapabilityFromLicense(asset, license);
        return productCapability != null;
    }

    public static Set<LicenseAssignRestriction> getLicenseAssignRestrictionsForAsset(com.vmware.license.client.cis.management.ds.License license, com.vmware.license.client.cis.management.ds.Asset asset) {
        if (asset == null) {
            return new HashSet<LicenseAssignRestriction>();
        }
        com.vmware.license.client.cis.management.ds.Asset[] assetArray = new com.vmware.license.client.cis.management.ds.Asset[]{asset};
        return AssetUtil.getLicenseAssignRestrictionsForAssets(license, assetArray);
    }

    public static Set<LicenseAssignRestriction> getLicenseAssignRestrictionsForAssets(com.vmware.license.client.cis.management.ds.License license, com.vmware.license.client.cis.management.ds.Asset[] assetArray) {
        HashSet<LicenseAssignRestriction> hashSet = new HashSet<LicenseAssignRestriction>();
        if (license == null || ArrayUtil.isNullOrEmpty((Object[])assetArray)) {
            return hashSet;
        }
        if (LicenseUtil.isExpiredLicense(license)) {
            hashSet.add(LicenseAssignRestriction.ExpiredLicense);
        }
        if (LicenseUtil.isEmbeddedOemLicense(license)) {
            for (com.vmware.license.client.cis.management.ds.Asset asset : assetArray) {
                ProductCapability productCapability;
                if (LicenseUtil.isEmbeddedOemLicense(asset.getLicense()) || !LicenseUtil.isAssignmentFromNonEoemRestricted(productCapability = AssetUtil.getAssetProductCapabilityFromLicense(asset, license))) continue;
                hashSet.add(LicenseAssignRestriction.EmbeddedOemLicense);
                break;
            }
        }
        return hashSet;
    }

    public static ProductRestriction getAssetProductRestriction(com.vmware.license.client.cis.management.ds.Asset asset) {
        if (asset == null) {
            return null;
        }
        return AssetUtil.getAssetProductRestrictionFromLicense(asset, asset.getLicense());
    }

    public static ProductRestriction getAssetProductRestrictionFromLicense(com.vmware.license.client.cis.management.ds.Asset asset, com.vmware.license.client.cis.management.ds.License license) {
        ProductRestriction[] productRestrictionArray = AssetUtil.getAssetProductRestrictionsFromLicense(asset, license);
        return ArrayUtil.isNullOrEmpty((Object[])productRestrictionArray) ? null : productRestrictionArray[0];
    }

    public static ProductCapability getAssetProductCapability(com.vmware.license.client.cis.management.ds.Asset asset) {
        if (asset == null) {
            return null;
        }
        return AssetUtil.getAssetProductCapabilityFromLicense(asset, asset.getLicense());
    }

    public static ProductCapability getAssetProductCapabilityFromLicense(com.vmware.license.client.cis.management.ds.Asset asset, com.vmware.license.client.cis.management.ds.License license) {
        ProductRestriction[] productRestrictionArray = AssetUtil.getAssetProductRestrictionsFromLicense(asset, license);
        if (ArrayUtil.isNullOrEmpty((Object[])productRestrictionArray)) {
            return null;
        }
        String string = asset.getVersion();
        if (string == null) {
            return productRestrictionArray[0].getLatestProductCapability();
        }
        ProductCapability productCapability = null;
        for (ProductRestriction productRestriction : productRestrictionArray) {
            ProductCapability productCapability2 = productRestriction.getVersionToProductCapability().get(string);
            if (productCapability2 == null) continue;
            productCapability = productCapability2;
            break;
        }
        return productCapability;
    }

    public static AssetType getServiceAssetType(Asset asset) {
        if (asset == null) {
            return null;
        }
        return ProductUtil.getAssetsTypeByProductFamilyName(asset.getInfo().getProduct().getFamily().getName());
    }

    public static AssetSearchProperties createAssetSearchProperties(AssetType assetType) {
        return AssetUtil.createAssetSearchProperties(assetType, null, null);
    }

    public static AssetSearchProperties createAssetSearchProperties(AssetType assetType, String string, Integer n) {
        AssetSearchProperties assetSearchProperties = new AssetSearchProperties();
        assetSearchProperties.setType(assetType);
        assetSearchProperties.setScopeId(string);
        assetSearchProperties.setMaxResultObjects(n);
        return assetSearchProperties;
    }

    private static void populateAssetInfo(com.vmware.license.client.cis.management.ds.Asset asset, AssetInfo assetInfo, LicenseScope licenseScope) {
        String string = assetInfo.getInstanceId();
        asset.setInstanceId(string);
        asset.setName(assetInfo.getName());
        asset.setVersion(assetInfo.getVersion());
        asset.setCostUnitUsage(CostUnitFactory.INSTANCE.createCostUnits(assetInfo.getCostUnitUsage(), null));
        asset.setFeaturesInUse(FeatureUtil.createFeatures(assetInfo.getFeaturesInUse()));
        ProductFamily productFamily = assetInfo.getProduct().getFamily();
        asset.setProductFamily(ProductUtil.createProductFamily(productFamily));
        AssetType assetType = ProductUtil.getAssetsTypeByProductFamilyName(productFamily.getName());
        asset.setType(assetType);
        License license = assetInfo.getLicense();
        com.vmware.license.client.cis.management.ds.License license2 = LicenseUtil.createLicense(license, assetInfo.isInEvaluation(), licenseScope);
        asset.setLicense(license2);
        asset.setEvaluationLicense(AssetUtil.getEvaluationInfo(assetInfo.getEvalInfo(), licenseScope));
        AssetLicenseState assetLicenseState = AssetUtil.getAssetLicenseState(license2);
        asset.setLicenseState(assetLicenseState);
    }

    private static com.vmware.license.client.cis.management.ds.License getEvaluationInfo(License license, LicenseScope licenseScope) {
        if (license == null) {
            return null;
        }
        return LicenseUtil.createEvaluationInfo(license, licenseScope);
    }

    private static ProductRestriction[] getAssetProductRestrictionsFromLicense(com.vmware.license.client.cis.management.ds.Asset asset, com.vmware.license.client.cis.management.ds.License license) {
        ProductRestriction[] productRestrictionArray;
        if (asset == null || license == null) {
            return null;
        }
        ArrayList<ProductRestriction> arrayList = new ArrayList<ProductRestriction>();
        for (ProductRestriction productRestriction : productRestrictionArray = license.getProductRestrictions()) {
            if (!ProductUtil.areProductFamiliesEqual(productRestriction.getProduct().getFamily(), asset.getProductFamily())) continue;
            arrayList.add(productRestriction);
        }
        return arrayList.toArray(new ProductRestriction[arrayList.size()]);
    }
}

