/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CostUnitUtil {
    public static final Number NO_LIMIT_VALUE = 0;
    public static final String COST_UNIT_CPU_PACKAGE = "cpuPackage";
    private static final String CPU_PACKAGE_CORE_LIMIT_DELIMITER = ":";
    private static final String CPU_PACKAGE_CORE_LIMIT_PREFIX = "cpuPackage:";
    private static final String CPU_PACKAGE_CORE_LIMIT_SUFFIX = "core";
    private static final String COST_UNIT_LOCALIZATION_KEY_FORMAT = "com.vmware.vim.license.CostUnit.%s.label";
    private static final String LEGACY_COST_UNIT_LOCALIZATION_KEY_FORMAT = "costUnit.%s.valueLabel";
    private static final String COST_UNIT_LOCALIZATION_KEY_LONG_FORMAT = "com.vmware.vim.license.CostUnit.%s.longLabel";
    private static final String LEGACY_COST_UNIT_LOCALIZATION_KEY_LONG_FORMAT = "costUnit.%s.longValueLabel";
    private static final String[] COST_UNIT_LOCALIZATION_KEY_FORMATS = new String[]{"com.vmware.vim.license.CostUnit.%s.label", "costUnit.%s.valueLabel"};
    private static final String[] COST_UNIT_LOCALIZATION_KEY_LONG_FORMATS = new String[]{"com.vmware.vim.license.CostUnit.%s.longLabel", "costUnit.%s.longValueLabel"};
    private static Localizer _messageLocalizer = new ManagementUtilLocalizer();

    static void setLocalizer(Localizer localizer) {
        _messageLocalizer = localizer;
    }

    public static void formatCostUnits(CostUnit[] costUnitArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitArray)) {
            return;
        }
        for (CostUnit costUnit : costUnitArray) {
            CostUnitUtil.formatCostUnit(costUnit);
        }
    }

    public static void formatCostUnit(CostUnit costUnit) {
        if (costUnit == null || costUnit.getId() == null) {
            return;
        }
        String string = CostUnitUtil.getShortFormattedCostUnitId(costUnit.getId());
        costUnit.setFormattedId(string);
        String string2 = "%s " + string;
        costUnit.setValueFormat(string2);
    }

    public static Set<String> getCostUnitIds(CostUnit[] costUnitArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitArray)) {
            return linkedHashSet;
        }
        for (CostUnit costUnit : costUnitArray) {
            linkedHashSet.add(costUnit.getId());
        }
        return linkedHashSet;
    }

    public static void addCostUnitUsages(CostUnit[] costUnitArray, CostUnit[] costUnitArray2) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitArray) || ArrayUtil.isNullOrEmpty((Object[])costUnitArray2)) {
            return;
        }
        for (CostUnit costUnit : costUnitArray) {
            if (costUnit.getUsage() == null) continue;
            for (CostUnit costUnit2 : costUnitArray2) {
                if (costUnit2.getUsage() == null || !costUnit2.getId().equals(costUnit.getId())) continue;
                Double d = costUnit2.getUsage() + costUnit.getUsage();
                costUnit2.setUsage(d);
            }
        }
    }

    public static String[] getShortFormattedCostUnitIds(CostUnit[] costUnitArray) {
        String[] stringArray = new String[costUnitArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = CostUnitUtil.getShortFormattedCostUnitId(costUnitArray[i].getId());
        }
        return stringArray;
    }

    public static String getShortFormattedCostUnitId(String string) {
        String string2 = CostUnitUtil.isCpuPackageCoreLimitCostUnit(string) != false ? COST_UNIT_CPU_PACKAGE : string;
        String string3 = CostUnitUtil.getCatalogFormattedCostUnitId(string2, COST_UNIT_LOCALIZATION_KEY_FORMATS, null);
        if (string3 == null) {
            string3 = CostUnitUtil.getLocalResourceBundleFormattedCostUnitId(string2, COST_UNIT_LOCALIZATION_KEY_FORMATS, new String[0]);
        }
        return string3 == null ? string : string3;
    }

    public static String[] getLongFormattedCostUnitIds(CostUnit[] costUnitArray) {
        String[] stringArray = new String[costUnitArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = CostUnitUtil.getLongFormattedCostUnitId(costUnitArray[i].getId());
        }
        return stringArray;
    }

    public static String getLongFormattedCostUnitId(String string) {
        String string2 = null;
        if (CostUnitUtil.isCpuPackageCoreLimitCostUnit(string).booleanValue()) {
            String string3 = CostUnitUtil.getCoreLimitValueFromCostUnitId(string);
            KeyAnyValueImpl keyAnyValueImpl = new KeyAnyValueImpl();
            keyAnyValueImpl.setKey("0");
            keyAnyValueImpl.setValue((Object)string3);
            string2 = CostUnitUtil.getCatalogFormattedCostUnitId(COST_UNIT_CPU_PACKAGE, COST_UNIT_LOCALIZATION_KEY_LONG_FORMATS, new KeyAnyValue[]{keyAnyValueImpl});
            if (string2 == null) {
                string2 = CostUnitUtil.getLocalResourceBundleFormattedCostUnitId(COST_UNIT_CPU_PACKAGE, COST_UNIT_LOCALIZATION_KEY_LONG_FORMATS, string3);
            }
        }
        if (string2 == null) {
            string2 = CostUnitUtil.getShortFormattedCostUnitId(string);
        }
        return string2 == null ? string : string2;
    }

    private static String getCatalogFormattedCostUnitId(String string, String[] stringArray, KeyAnyValue[] keyAnyValueArray) {
        for (String string2 : stringArray) {
            String string3 = String.format(string2, string);
            String string4 = _messageLocalizer.getCatalogLocalizedString(string3, keyAnyValueArray);
            if (string4 == null) continue;
            return string4;
        }
        return null;
    }

    private static String getLocalResourceBundleFormattedCostUnitId(String string, String[] stringArray, String ... stringArray2) {
        for (String string2 : stringArray) {
            String string3 = String.format(string2, string);
            String string4 = _messageLocalizer.getLocalizedString(string3, stringArray2);
            if (string4 == null) continue;
            return string4;
        }
        return null;
    }

    private static Boolean isCpuPackageCoreLimitCostUnit(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return false;
        }
        return string.startsWith(CPU_PACKAGE_CORE_LIMIT_PREFIX) && string.endsWith(CPU_PACKAGE_CORE_LIMIT_SUFFIX);
    }

    private static String getCoreLimitValueFromCostUnitId(String string) {
        return StringUtils.substringBetween((String)string, (String)CPU_PACKAGE_CORE_LIMIT_DELIMITER, (String)CPU_PACKAGE_CORE_LIMIT_SUFFIX);
    }

    static class ManagementUtilLocalizer
    implements Localizer {
        ManagementUtilLocalizer() {
        }

        @Override
        public String getCatalogLocalizedString(String string, KeyAnyValue[] keyAnyValueArray) {
            return ManagementUtil.getCatalogLocalizedString(string, keyAnyValueArray);
        }

        @Override
        public String getLocalizedString(String string, String ... stringArray) {
            return ManagementUtil.getLocalizedString(string, stringArray);
        }
    }

    static interface Localizer {
        public String getCatalogLocalizedString(String var1, KeyAnyValue[] var2);

        public String getLocalizedString(String var1, String ... var2);
    }
}

