/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;

public class ManagementUtil {
    public static final boolean VSAN_LICENSING_ENABLED = true;
    public static final String SCOPE_PROPERTY_NAME = "scope";
    public static final LicenseScope SCOPE_CIS_LICENSING = new LicenseScope("licensing_service_version1");
    private static final String LICENSE_SERVICE_STRINGS = "licenseservice";

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static String getCatalogLocalizedString(String string) {
        return ManagementUtil.getCatalogLocalizedString(string, null);
    }

    public static String getCatalogLocalizedString(String string, KeyAnyValue[] keyAnyValueArray) {
        String string2 = LocalizationUtil.getLocalizedMessage((String)string, (KeyAnyValue[])keyAnyValueArray);
        return ManagementUtil.isStringLocalized(string2, string) ? string2 : null;
    }

    public static String getLocalizedString(String string) {
        return ManagementUtil.getLocalizedString(string, new String[]{null});
    }

    public static String getLocalizedString(String string, String ... stringArray) {
        String string2 = ResourceUtil.getString((String)LICENSE_SERVICE_STRINGS, (String)string, (String[])stringArray, (ClassLoader)ManagementUtil.class.getClassLoader());
        return ManagementUtil.isStringLocalized(string2, string) ? string2 : null;
    }

    public static <T> T getKeyAnyValuePropertyValue(String string, KeyAnyValue[] keyAnyValueArray) {
        if (string == null || ArrayUtil.isNullOrEmpty((Object[])keyAnyValueArray)) {
            return null;
        }
        for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
            if (!string.equals(keyAnyValue.getKey())) continue;
            return (T)keyAnyValue.getValue();
        }
        return null;
    }

    public static String getFormattedDate(Date date) {
        if (date == null) {
            return null;
        }
        DateFormat dateFormat = DateFormat.getDateInstance(2, ResourceUtil.getLocale());
        return dateFormat.format(date);
    }

    private static boolean isStringLocalized(String string, String string2) {
        return !ObjectUtil.objectsEqual((Object)string, (Object)string2);
    }
}

