/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.AssetType;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.Product;
import com.vmware.license.client.cis.management.impl.CostUnitFactory;
import com.vmware.license.client.cis.management.util.CostUnitUtil;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vim.binding.cis.license.CostUnitLimit;
import com.vmware.vim.binding.cis.license.CostUnitUsage;
import com.vmware.vim.binding.cis.license.ProductFamily;
import com.vmware.vise.util.ArrayUtil;
import java.net.URI;
import org.apache.commons.lang.StringUtils;

public class ProductUtil {
    public static final String HOST_PRODUCT_FAMILY_NAME = "VMware ESX Server";
    public static final String VC_PRODUCT_FAMILY_NAME = "VMware VirtualCenter Server";
    public static final String CLUSTER_PRODUCT_FAMILY_NAME = "VMware VSAN";
    private static final String LICENSE_DECODE_FAILED_ERROR = "DecodeError";
    private static final String LICENSE_NOT_FOUND_ERROR = "NotFoundError";

    public static Product createProduct(com.vmware.vim.binding.cis.license.Product product, CostUnitUsage[] costUnitUsageArray, CostUnitLimit[] costUnitLimitArray, LicenseScope licenseScope) {
        if (ProductUtil.isProductCorrupted(product)) {
            return null;
        }
        URI uRI = licenseScope == null ? null : UriUtil.buildProductUri(product.getId(), licenseScope);
        com.vmware.license.client.cis.management.ds.ProductFamily productFamily = ProductUtil.createProductFamily(product.getFamily());
        CostUnit[] costUnitArray = CostUnitFactory.INSTANCE.createCostUnits(costUnitUsageArray, costUnitLimitArray);
        return ProductUtil.createProduct(uRI, product.getName(), product.getSuiteName(), productFamily, costUnitArray);
    }

    public static Product createProduct(URI uRI, String string, String string2, com.vmware.license.client.cis.management.ds.ProductFamily productFamily, CostUnit[] costUnitArray) {
        Product product = new Product();
        product.setUri(uRI);
        product.setName(string);
        product.setSuiteName(string2);
        product.setFamily(productFamily);
        product.setCostUnits(costUnitArray == null ? new CostUnit[]{} : costUnitArray);
        if (productFamily != null) {
            AssetType assetType = ProductUtil.getAssetsTypeByProductFamilyName(productFamily.getName());
            product.setAssetsType(assetType);
        }
        return product;
    }

    public static com.vmware.license.client.cis.management.ds.ProductFamily createProductFamily(ProductFamily productFamily) {
        if (productFamily == null) {
            return null;
        }
        com.vmware.license.client.cis.management.ds.ProductFamily productFamily2 = ProductUtil.createProductFamily(productFamily.getName(), productFamily.getVersion());
        return productFamily2;
    }

    public static com.vmware.license.client.cis.management.ds.ProductFamily createProductFamily(String string, String string2) {
        com.vmware.license.client.cis.management.ds.ProductFamily productFamily = new com.vmware.license.client.cis.management.ds.ProductFamily();
        productFamily.setName(string);
        productFamily.setVersion(string2);
        return productFamily;
    }

    public static AssetType getAssetsTypeByProductFamilyName(String string) {
        AssetType assetType = AssetType.SOLUTION;
        boolean bl = true;
        if (string == null) {
            assetType = AssetType.UNKNOWN;
        } else if (HOST_PRODUCT_FAMILY_NAME.equals(string)) {
            assetType = AssetType.HOST;
        } else if (VC_PRODUCT_FAMILY_NAME.equals(string)) {
            assetType = AssetType.VC;
        } else if (bl && CLUSTER_PRODUCT_FAMILY_NAME.equals(string)) {
            assetType = AssetType.CLUSTER;
        }
        return assetType;
    }

    public static String getProductFamilyName(AssetType assetType) {
        String string = null;
        if (AssetType.HOST.equals((Object)assetType)) {
            string = HOST_PRODUCT_FAMILY_NAME;
        } else if (AssetType.VC.equals((Object)assetType)) {
            string = VC_PRODUCT_FAMILY_NAME;
        } else if (AssetType.CLUSTER.equals((Object)assetType)) {
            string = CLUSTER_PRODUCT_FAMILY_NAME;
        }
        return string;
    }

    public static boolean areProductFamiliesEqual(com.vmware.license.client.cis.management.ds.ProductFamily productFamily, com.vmware.license.client.cis.management.ds.ProductFamily productFamily2) {
        if (productFamily == null || productFamily2 == null) {
            return false;
        }
        return productFamily.getName().equals(productFamily2.getName()) && productFamily.getVersion().equals(productFamily2.getVersion());
    }

    public static String getFormattedName(String string, CostUnit[] costUnitArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])costUnitArray)) {
            return string;
        }
        Object[] objectArray = CostUnitUtil.getLongFormattedCostUnitIds(costUnitArray);
        String string2 = ManagementUtil.getLocalizedString("product.costUnitDelim");
        String string3 = StringUtils.join((Object[])objectArray, (String)string2);
        return ManagementUtil.getLocalizedString("product.nameFormat", string, string3);
    }

    public static boolean isProductCorrupted(com.vmware.vim.binding.cis.license.Product product) {
        if (product == null) {
            return false;
        }
        String string = product.getId();
        return LICENSE_DECODE_FAILED_ERROR.equals(string) || LICENSE_NOT_FOUND_ERROR.equals(string);
    }
}

