/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.SubscriptionEntitlementAccount;
import com.vmware.license.client.cis.management.ds.SubscriptionInfo;
import com.vmware.license.client.cis.management.ds.SubscriptionService;
import com.vmware.license.client.cis.management.ds.results.AddSubscriptionLicensePreviewResult;
import com.vmware.vim.binding.cis.license.LicenseInfo;
import com.vmware.vim.binding.cis.license.LicenseUtilization;
import com.vmware.vim.binding.cis.license.SubscriptionLicenseInfo;

public class SubscriptionLicensingUtil {
    public static boolean isSubscriptionLicensingEnabled() {
        return false;
    }

    public static boolean isSubscriptionLicense(License license) {
        if (license == null || !SubscriptionLicensingUtil.isSubscriptionLicensingEnabled()) {
            return false;
        }
        return license.getSubscriptionInfo() != null;
    }

    public static AddSubscriptionLicensePreviewResult buildAddSubscriptionLicensePreviewResult(LicenseInfo[] licenseInfoArray) {
        LicenseInfo licenseInfo;
        int n;
        LicenseInfo[] object = licenseInfoArray;
        int subscriptionInfoArray = object.length;
        for (n = 0; n < subscriptionInfoArray; ++n) {
            licenseInfo = object[n];
            if (SubscriptionLicensingUtil.isSubscriptionLicenseInfo(licenseInfo)) continue;
            throw new IllegalArgumentException("The runtime type of the provided license infos is not SubscriptionLicenseInfo.");
        }
        AddSubscriptionLicensePreviewResult addSubscriptionLicensePreviewResult = new AddSubscriptionLicensePreviewResult();
        SubscriptionInfo[] subscriptionInfoArray2 = new SubscriptionInfo[licenseInfoArray.length];
        for (n = 0; n < licenseInfoArray.length; ++n) {
            licenseInfo = (SubscriptionLicenseInfo)licenseInfoArray[n];
            SubscriptionEntitlementAccount subscriptionEntitlementAccount = SubscriptionLicensingUtil.buildSubscriptionEntitlementAccount((SubscriptionLicenseInfo)licenseInfo);
            SubscriptionService subscriptionService = SubscriptionLicensingUtil.buildSubscriptionService((SubscriptionLicenseInfo)licenseInfo);
            subscriptionInfoArray2[n] = SubscriptionLicensingUtil.buildSubscriptionInfo(subscriptionEntitlementAccount, subscriptionService);
        }
        addSubscriptionLicensePreviewResult.subscriptions = subscriptionInfoArray2;
        return addSubscriptionLicensePreviewResult;
    }

    public static com.vmware.license.client.cis.management.ds.SubscriptionLicenseInfo buildSubscriptionLicenseInfo(LicenseInfo licenseInfo) {
        if (!SubscriptionLicensingUtil.isSubscriptionLicenseInfo(licenseInfo)) {
            return null;
        }
        SubscriptionLicenseInfo subscriptionLicenseInfo = (SubscriptionLicenseInfo)licenseInfo;
        SubscriptionEntitlementAccount subscriptionEntitlementAccount = SubscriptionLicensingUtil.buildSubscriptionEntitlementAccount(subscriptionLicenseInfo);
        SubscriptionService subscriptionService = SubscriptionLicensingUtil.buildSubscriptionService(subscriptionLicenseInfo);
        com.vmware.license.client.cis.management.ds.SubscriptionLicenseInfo subscriptionLicenseInfo2 = new com.vmware.license.client.cis.management.ds.SubscriptionLicenseInfo();
        subscriptionLicenseInfo2.setUserName(subscriptionLicenseInfo.getUsername());
        subscriptionLicenseInfo2.setEntitlementAccount(subscriptionEntitlementAccount);
        subscriptionLicenseInfo2.setService(subscriptionService);
        return subscriptionLicenseInfo2;
    }

    public static boolean isSubscriptionLicenseUtilization(LicenseUtilization licenseUtilization) {
        if (licenseUtilization == null) {
            return false;
        }
        return SubscriptionLicensingUtil.isSubscriptionLicenseInfo(licenseUtilization.getLicense().getInfo());
    }

    public static boolean isSubscriptionLicenseInfo(LicenseInfo licenseInfo) {
        return SubscriptionLicensingUtil.isSubscriptionLicensingEnabled() && licenseInfo instanceof SubscriptionLicenseInfo;
    }

    private static SubscriptionService buildSubscriptionService(SubscriptionLicenseInfo subscriptionLicenseInfo) {
        SubscriptionService subscriptionService = new SubscriptionService();
        subscriptionService.setServiceId(subscriptionLicenseInfo.getSubscriptionServiceInfo().getId());
        subscriptionService.setProperties(subscriptionLicenseInfo.getSubscriptionServiceInfo().getProperties());
        return subscriptionService;
    }

    private static SubscriptionEntitlementAccount buildSubscriptionEntitlementAccount(SubscriptionLicenseInfo subscriptionLicenseInfo) {
        SubscriptionEntitlementAccount subscriptionEntitlementAccount = new SubscriptionEntitlementAccount();
        subscriptionEntitlementAccount.setNumber(subscriptionLicenseInfo.getEntitlementAccountInfo().getNumber());
        subscriptionEntitlementAccount.setName(subscriptionLicenseInfo.getEntitlementAccountInfo().getName());
        return subscriptionEntitlementAccount;
    }

    private static SubscriptionInfo buildSubscriptionInfo(SubscriptionEntitlementAccount subscriptionEntitlementAccount, SubscriptionService subscriptionService) {
        SubscriptionInfo subscriptionInfo = new SubscriptionInfo();
        subscriptionInfo.entitlementAccount = subscriptionEntitlementAccount;
        subscriptionInfo.service = subscriptionService;
        return subscriptionInfo;
    }
}

