/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.reports.LicenseReportScope;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.web.util.UriUtils;

public class UriUtil {
    public static final String LICENSING_GLOBAL_DATA_TYPE = "LicensingGlobalData";
    public static final String PRODUCT_TYPE = "Product";
    public static final String LICENSE_TYPE = "License";
    public static final String ASSET_TYPE = "Asset";
    public static final String PRODUCT_REPORT_TYPE = "ProductReport";
    public static final String LICENSE_REPORT_TYPE = "CisLicenseReport";
    public static final String ASSET_REPORT_TYPE = "AssetReport";
    public static final String LICENSING_DATA_DUMP_REPORT_TYPE = "LicensingDataDumpReport";
    public static final String SYNC_INFO_OBJECT_TYPE = "MyVMwareSyncInfo";
    public static final LicenseScope EXTERNAL_SCOPE = new LicenseScope("ExternalScope");
    private static final String EXTERNAL_STRING_ID = "ExternalId";
    private static final URI EXTERNAL_URI_ID = DefaultUriSchemeUtil.createUri((String)"ExternalObject", (String)"id");
    private static final int URI_ID_INDEX = 0;
    private static final int URI_SCOPE_ID_INDEX = 1;
    private static final int URI_START_DATE_INDEX = 2;
    private static final int URI_END_DATE_INDEX = 3;
    private static final String CHARACTER_ENCODING = "UTF-8";

    public static boolean containsSingleUriWithType(Object[] objectArray, String string) {
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || objectArray.length != 1) {
            return false;
        }
        Object object = objectArray[0];
        if (!(object instanceof URI)) {
            return false;
        }
        return UriUtil.isUriOfType((URI)object, string);
    }

    public static Date getStartDate(URI uRI) {
        String string = UriUtil.getUriValueSegment(uRI, 2);
        return new Date(Long.parseLong(string));
    }

    public static Date getEndDate(URI uRI) {
        String string = UriUtil.getUriValueSegment(uRI, 3);
        return new Date(Long.parseLong(string));
    }

    public static String getLicenseScopeId(URI uRI) {
        if (uRI == null) {
            return null;
        }
        String string = DefaultUriSchemeUtil.getType((URI)uRI);
        String string2 = LICENSING_GLOBAL_DATA_TYPE.equals(string) ? DefaultUriSchemeUtil.getId((URI)uRI) : UriUtil.getUriValueSegment(uRI, 1);
        return string2;
    }

    public static URI[] extractObjectIdsAsUris(URI[] uRIArray) {
        if (uRIArray == null) {
            return null;
        }
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (int i = 0; i < uRIArray.length; ++i) {
            arrayList.add(UriUtil.extractObjectIdAsUri(uRIArray[i]));
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    public static String[] extractObjectIdsAsStrings(URI[] uRIArray) {
        if (uRIArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < uRIArray.length; ++i) {
            arrayList.add(UriUtil.extractObjectIdAsString(uRIArray[i]));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String extractObjectIdAsString(URI uRI) {
        String string = UriUtil.getUriValueSegment(uRI, 0);
        try {
            return UriUtils.decode((String)string, (String)CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }

    public static URI extractObjectIdAsUri(URI uRI) {
        try {
            return new URI(UriUtil.extractObjectIdAsString(uRI));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("objectUri is not a valid URI");
        }
    }

    public static URI buildLicenseUri(URI uRI, LicenseScope licenseScope) {
        return UriUtil.buildScopeUri(LICENSE_TYPE, uRI, licenseScope);
    }

    public static URI buildExternalLicenseUri() {
        return UriUtil.buildLicenseUri(EXTERNAL_URI_ID, EXTERNAL_SCOPE);
    }

    public static URI buildProductUri(String string, LicenseScope licenseScope) {
        return UriUtil.buildScopeUri(PRODUCT_TYPE, string, licenseScope);
    }

    public static URI buildExternalProductUri() {
        return UriUtil.buildProductUri(EXTERNAL_STRING_ID, EXTERNAL_SCOPE);
    }

    public static URI buildAssetUri(URI uRI, LicenseScope licenseScope) {
        return UriUtil.buildScopeUri(ASSET_TYPE, uRI, licenseScope);
    }

    public static URI buildExternalAssetUri() {
        return UriUtil.buildAssetUri(EXTERNAL_URI_ID, EXTERNAL_SCOPE);
    }

    public static URI buildProductReportUri(String string, LicenseReportScope licenseReportScope) {
        URI uRI = DefaultUriSchemeUtil.createUri((String)PRODUCT_REPORT_TYPE, (String[])UriUtil.buildIdSegments(UriUtil.getEncodedId(string), licenseReportScope));
        return uRI;
    }

    public static URI buildLicenseReportUri(URI uRI, LicenseReportScope licenseReportScope) {
        URI uRI2 = DefaultUriSchemeUtil.createUri((String)LICENSE_REPORT_TYPE, (String[])UriUtil.buildIdSegments(uRI, licenseReportScope));
        return uRI2;
    }

    public static URI buildAssetReportUri(URI uRI, LicenseReportScope licenseReportScope) {
        URI uRI2 = DefaultUriSchemeUtil.createUri((String)ASSET_REPORT_TYPE, (String[])UriUtil.buildIdSegments(uRI, licenseReportScope));
        return uRI2;
    }

    public static URI buildLicensingDataDumpReportUri(LicenseReportScope licenseReportScope) {
        return DefaultUriSchemeUtil.createUri((String)LICENSING_DATA_DUMP_REPORT_TYPE, (String[])UriUtil.buildIdSegments("", licenseReportScope));
    }

    public static void validateLicenseUri(URI uRI) {
        UriUtil.validateUri(uRI, LICENSE_TYPE);
    }

    public static void validateProductUri(URI uRI) {
        UriUtil.validateUri(uRI, PRODUCT_TYPE);
    }

    public static void validateAssetUri(URI uRI) {
        UriUtil.validateUri(uRI, ASSET_TYPE);
    }

    public static void validateProductReportUri(URI uRI) {
        UriUtil.validateUri(uRI, PRODUCT_REPORT_TYPE);
    }

    public static void validateUri(URI uRI, String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{uRI, string});
        UriUtil.validateUris(new URI[]{uRI}, string);
    }

    public static void validateUris(URI[] uRIArray, String string) {
        if (string == null) {
            throw new IllegalArgumentException("type should not be null.");
        }
        if (ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
            return;
        }
        for (URI uRI : uRIArray) {
            if (string.equals(DefaultUriSchemeUtil.getType((URI)uRI))) continue;
            String string2 = String.format("Wrong type for URI [%1$S]. Expected type [%2$S]", uRI, string);
            throw new IllegalArgumentException(string2);
        }
    }

    public static void validateLicenseUris(URI[] uRIArray) {
        UriUtil.validateUris(uRIArray, LICENSE_TYPE);
    }

    public static void validateProductUris(URI[] uRIArray) {
        UriUtil.validateUris(uRIArray, PRODUCT_TYPE);
    }

    public static void validateAssetUris(URI[] uRIArray) {
        UriUtil.validateUris(uRIArray, ASSET_TYPE);
    }

    public static void validateProductReportUris(URI[] uRIArray) {
        UriUtil.validateUris(uRIArray, PRODUCT_REPORT_TYPE);
    }

    public static boolean isLicenseUri(URI uRI) {
        return UriUtil.isUriOfType(uRI, LICENSE_TYPE);
    }

    public static boolean isProductUri(URI uRI) {
        return UriUtil.isUriOfType(uRI, PRODUCT_TYPE);
    }

    public static boolean isAssetUri(URI uRI) {
        return UriUtil.isUriOfType(uRI, ASSET_TYPE);
    }

    public static boolean isProductReportUri(URI uRI) {
        return UriUtil.isUriOfType(uRI, PRODUCT_REPORT_TYPE);
    }

    public static boolean isUriOfType(URI uRI, String string) {
        String string2 = DefaultUriSchemeUtil.getType((URI)uRI);
        return string.equals(string2);
    }

    private static URI buildScopeUri(String string, URI uRI, LicenseScope licenseScope) {
        return UriUtil.buildScopeUri(string, uRI.toString(), licenseScope);
    }

    private static String[] buildIdSegments(String string, LicenseReportScope licenseReportScope) {
        return new String[]{string, licenseReportScope.getLicenseScope().getId(), Long.toString(licenseReportScope.getStartDate().getTime()), Long.toString(licenseReportScope.getEndDate().getTime())};
    }

    private static String[] buildIdSegments(URI uRI, LicenseReportScope licenseReportScope) {
        return UriUtil.buildIdSegments(UriUtil.getEncodedId(uRI.toString()), licenseReportScope);
    }

    private static URI buildScopeUri(String string, String string2, LicenseScope licenseScope) {
        String string3 = UriUtil.getEncodedId(string2);
        String[] stringArray = new String[]{string3, licenseScope.getId()};
        return DefaultUriSchemeUtil.createUri((String)string, (String[])stringArray);
    }

    private static String getEncodedId(String string) {
        String string2;
        try {
            string2 = UriUtils.encodeScheme((String)string, (String)CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return string2;
    }

    private static String getUriValueSegment(URI uRI, int n) {
        String[] stringArray = DefaultUriSchemeUtil.getIdSegments((URI)uRI);
        return stringArray.length > n ? stringArray[n] : "";
    }
}

