/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.adapter;

import com.vmware.license.client.cis.myvmwaresync.MyVMwareOnlineSyncEditor;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncCheckReportGenerationStatusResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncCredentialsResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncFoldersResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncInitiateReportGenerationResult;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareOnlineSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncCheckReportGenerationStatusSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncCredentialsSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncFoldersSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncInitiateReportGenerationSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareOnlineSyncPreviewSpec;
import com.vmware.license.client.cis.myvmwaresync.util.MyVMwareApiExceptionUtil;
import com.vmware.license.client.cis.util.MutationUtil;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyVMwareOnlineSyncMutationProvider
implements MutationProvider {
    private final Log _logger = LogFactory.getLog(MyVMwareOnlineSyncMutationProvider.class);
    private final MyVMwareOnlineSyncEditor _myVMwareOnlineSyncEditor;

    public MyVMwareOnlineSyncMutationProvider(MyVMwareOnlineSyncEditor myVMwareOnlineSyncEditor) {
        this._myVMwareOnlineSyncEditor = myVMwareOnlineSyncEditor;
    }

    public ValidationResult validate(MyVMwareOnlineSyncCredentialsSpec myVMwareOnlineSyncCredentialsSpec) {
        try {
            MyVMwareOnlineSyncCredentialsResult myVMwareOnlineSyncCredentialsResult = this._myVMwareOnlineSyncEditor.getUserEntitlementAccounts(myVMwareOnlineSyncCredentialsSpec);
            return MutationUtil.createValidationResult((Object)myVMwareOnlineSyncCredentialsResult);
        }
        catch (Exception exception) {
            this.logError(exception);
            return this.createExceptionValidationResult(exception);
        }
    }

    public ValidationResult validate(MyVMwareOnlineSyncFoldersSpec myVMwareOnlineSyncFoldersSpec) {
        try {
            MyVMwareOnlineSyncFoldersResult myVMwareOnlineSyncFoldersResult = this._myVMwareOnlineSyncEditor.getEntitlementAccountFolders(myVMwareOnlineSyncFoldersSpec);
            return MutationUtil.createValidationResult((Object)myVMwareOnlineSyncFoldersResult);
        }
        catch (Exception exception) {
            this.logError(exception);
            return this.createExceptionValidationResult(exception);
        }
    }

    public ValidationResult validate(MyVMwareOnlineSyncInitiateReportGenerationSpec myVMwareOnlineSyncInitiateReportGenerationSpec) {
        try {
            MyVMwareOnlineSyncInitiateReportGenerationResult myVMwareOnlineSyncInitiateReportGenerationResult = this._myVMwareOnlineSyncEditor.initiateReportGeneration(myVMwareOnlineSyncInitiateReportGenerationSpec);
            return MutationUtil.createValidationResult((Object)myVMwareOnlineSyncInitiateReportGenerationResult);
        }
        catch (Exception exception) {
            this.logError(exception);
            return this.createExceptionValidationResult(exception);
        }
    }

    public ValidationResult validate(MyVMwareOnlineSyncCheckReportGenerationStatusSpec myVMwareOnlineSyncCheckReportGenerationStatusSpec) {
        try {
            MyVMwareOnlineSyncCheckReportGenerationStatusResult myVMwareOnlineSyncCheckReportGenerationStatusResult = this._myVMwareOnlineSyncEditor.checkReportGenerationStatus(myVMwareOnlineSyncCheckReportGenerationStatusSpec);
            return MutationUtil.createValidationResult((Object)myVMwareOnlineSyncCheckReportGenerationStatusResult);
        }
        catch (Exception exception) {
            this.logError(exception);
            return this.createExceptionValidationResult(exception);
        }
    }

    public ValidationResult validate(MyVMwareOnlineSyncPreviewSpec myVMwareOnlineSyncPreviewSpec) {
        try {
            MyVMwareOnlineSyncPreviewResult myVMwareOnlineSyncPreviewResult = this._myVMwareOnlineSyncEditor.previewOnlineSync(myVMwareOnlineSyncPreviewSpec);
            return MutationUtil.createValidationResult((Object)myVMwareOnlineSyncPreviewResult);
        }
        catch (Exception exception) {
            this.logError(exception);
            return this.createExceptionValidationResult(exception);
        }
    }

    private ValidationResult createExceptionValidationResult(Throwable throwable) {
        Exception exception = MyVMwareApiExceptionUtil.convertToLocalizedException(throwable);
        ValidationResult validationResult = new ValidationResult();
        validationResult.error = exception;
        return validationResult;
    }

    private void logError(Throwable throwable) {
        if (this._logger.isErrorEnabled()) {
            this._logger.error((Object)"Unable to execute My VMware online sync mutation operation: ", throwable);
        }
    }
}

