/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.client.impl;

import com.vmware.license.client.cis.myvmwaresync.client.MyVMwareClientProvider;
import com.vmware.license.client.cis.myvmwaresync.client.MyVMwareClientProviderException;
import com.vmware.license.client.cis.myvmwaresync.client.MyVMwareClientProviderResult;
import com.vmware.license.client.cis.myvmwaresync.client.impl.MyVMwareClientAuthenticationConfig;
import com.vmware.license.client.cis.myvmwaresync.client.impl.MyVMwareClientHttpConfig;
import com.vmware.license.myvmware.client.authn.AuthenticationToken;
import com.vmware.license.myvmware.client.authn.AuthenticationTokenFactory;
import com.vmware.license.myvmware.client.authn.impl.AuthenticationTokenFactoryImpl;
import com.vmware.license.myvmware.client.entitlementreport.MyVMwareEntitlementReportClient;
import com.vmware.license.myvmware.client.entitlementreport.MyVMwareEntitlementReportClientFactory;
import com.vmware.license.myvmware.client.entitlementreport.impl.MyVMwareEntitlementReportClientFactoryImpl;
import java.net.URI;

public class MyVMwareClientProviderImpl
implements MyVMwareClientProvider {
    private String _apiBaseUri;
    private final MyVMwareEntitlementReportClientFactory _myVMwareClientFactory;
    private final AuthenticationTokenFactory _authenticationTokenFactory;

    public MyVMwareClientProviderImpl(String string) {
        this(string, null, null);
    }

    public MyVMwareClientProviderImpl(String string, MyVMwareClientAuthenticationConfig myVMwareClientAuthenticationConfig) {
        this(string, null, myVMwareClientAuthenticationConfig);
    }

    public MyVMwareClientProviderImpl(String string, MyVMwareClientHttpConfig myVMwareClientHttpConfig) {
        this(string, myVMwareClientHttpConfig, null);
    }

    public MyVMwareClientProviderImpl(String string, MyVMwareClientHttpConfig myVMwareClientHttpConfig, MyVMwareClientAuthenticationConfig myVMwareClientAuthenticationConfig) {
        this._apiBaseUri = string;
        this._myVMwareClientFactory = myVMwareClientHttpConfig == null ? new MyVMwareEntitlementReportClientFactoryImpl() : new MyVMwareEntitlementReportClientFactoryImpl(myVMwareClientHttpConfig.toMyVMwareEntitlementReportClientHttpConfig());
        this._authenticationTokenFactory = myVMwareClientAuthenticationConfig == null ? new AuthenticationTokenFactoryImpl() : new AuthenticationTokenFactoryImpl(myVMwareClientAuthenticationConfig.toAuthenticationConfig());
    }

    @Override
    public MyVMwareClientProviderResult newClient(AuthenticationToken authenticationToken) throws MyVMwareClientProviderException {
        MyVMwareEntitlementReportClient myVMwareEntitlementReportClient;
        if (authenticationToken == null) {
            throw new IllegalArgumentException("The authentication token parameter cannot be null.");
        }
        try {
            myVMwareEntitlementReportClient = this._myVMwareClientFactory.createClient(new URI(this._apiBaseUri), authenticationToken);
        }
        catch (Exception exception) {
            throw new MyVMwareClientProviderException(exception);
        }
        return new MyVMwareClientProviderResult(myVMwareEntitlementReportClient, authenticationToken);
    }

    @Override
    public MyVMwareClientProviderResult newClient(String string, String string2) throws MyVMwareClientProviderException {
        AuthenticationToken authenticationToken;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Both the username and password parameters should be non-null.");
        }
        try {
            authenticationToken = this._authenticationTokenFactory.createToken(string, string2);
        }
        catch (Exception exception) {
            throw new MyVMwareClientProviderException(exception);
        }
        MyVMwareClientProviderResult myVMwareClientProviderResult = this.newClient(authenticationToken);
        return myVMwareClientProviderResult;
    }
}

