/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.adapter;

import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.reports.ReportEditor;
import com.vmware.license.client.cis.reports.adapter.AssetReportPropertyProviderBean;
import com.vmware.license.client.cis.reports.adapter.BaseReportDataProviderAdapterImpl;
import com.vmware.license.client.cis.reports.ds.AssetReport;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.type;
import java.net.URI;

@type(value="AssetReport")
public class AssetReportDataProviderAdapterImpl
extends BaseReportDataProviderAdapterImpl<AssetReport> {
    private static final String PROPERTY_NAME_LICENSE_REPORT_URI = "licenseReportUri";
    private static final String PROPERTY_NAME_COST_UNIT_ID = "costUnitId";
    private static final String RELATION_ASSET_REPORTS = "assetReports";
    private final ReportEditor _reportEditor;

    public AssetReportDataProviderAdapterImpl(ReportEditor reportEditor) {
        this._reportEditor = reportEditor;
    }

    @Override
    protected BasePropertyProviderBean<AssetReport> getPropertyProvider() {
        return new AssetReportPropertyProviderBean();
    }

    @Override
    protected String getProvidedType() {
        return "AssetReport";
    }

    @Override
    protected URI getUri(AssetReport assetReport) {
        return assetReport.getUri();
    }

    protected AssetReport[] getObjectsByRelationalConstraint(RelationalConstraint relationalConstraint) {
        String string = relationalConstraint.relation;
        if (!RELATION_ASSET_REPORTS.equals(string) || !(relationalConstraint.constraintOnRelatedObject instanceof CompositeConstraint)) {
            return (AssetReport[])super.getObjectsByRelationalConstraint(relationalConstraint);
        }
        CompositeConstraint compositeConstraint = (CompositeConstraint)relationalConstraint.constraintOnRelatedObject;
        String string2 = null;
        URI uRI = null;
        URI uRI2 = null;
        for (Constraint constraint : compositeConstraint.nestedConstraints) {
            PropertyConstraint propertyConstraint;
            if (constraint instanceof PropertyConstraint) {
                propertyConstraint = (PropertyConstraint)constraint;
                if (PROPERTY_NAME_COST_UNIT_ID.equals(propertyConstraint.propertyName)) {
                    string2 = (String)propertyConstraint.comparableValue;
                    continue;
                }
                if (!PROPERTY_NAME_LICENSE_REPORT_URI.equals(propertyConstraint.propertyName)) continue;
                uRI = (URI)propertyConstraint.comparableValue;
                continue;
            }
            if (!(constraint instanceof ObjectIdentityConstraint)) continue;
            propertyConstraint = (ObjectIdentityConstraint)constraint;
            if (!(propertyConstraint.target instanceof URI)) continue;
            uRI2 = (URI)propertyConstraint.target;
        }
        if (uRI == null || uRI2 == null) {
            return (AssetReport[])super.getObjectsByRelationalConstraint(relationalConstraint);
        }
        return this._reportEditor.getAssetReports(uRI2, uRI, string2);
    }
}

