/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.reports.impl;

import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.util.CostUnitUtil;
import com.vmware.license.client.cis.management.util.ProductUtil;
import com.vmware.license.client.cis.reports.ReportObjectsFormatter;
import com.vmware.license.client.cis.reports.ds.AssetReport;
import com.vmware.license.client.cis.reports.ds.LicenseReport;
import com.vmware.license.client.cis.reports.ds.LicensingDataDumpReport;
import com.vmware.license.client.cis.reports.ds.ProductReport;
import com.vmware.vise.util.ArrayUtil;

public class ReportObjectsFormatterImpl
implements ReportObjectsFormatter {
    @Override
    public void formatProductReports(ProductReport[] productReportArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])productReportArray)) {
            return;
        }
        for (ProductReport productReport : productReportArray) {
            CostUnit[] costUnitArray = productReport.getCostUnits();
            CostUnitUtil.formatCostUnits(costUnitArray);
            String string = ProductUtil.getFormattedName(productReport.getName(), costUnitArray);
            productReport.setName(string);
        }
    }

    @Override
    public void formatLicenseReports(LicenseReport[] licenseReportArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])licenseReportArray)) {
            return;
        }
        for (LicenseReport licenseReport : licenseReportArray) {
            this.formatProductReports(licenseReport.getProductReports());
        }
    }

    @Override
    public void formatAssetReports(AssetReport[] assetReportArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])assetReportArray)) {
            return;
        }
        for (AssetReport assetReport : assetReportArray) {
            CostUnitUtil.formatCostUnits(assetReport.getCostUnitUsage());
        }
    }

    @Override
    public void formatLicensingDataDumpReports(LicensingDataDumpReport[] licensingDataDumpReportArray) {
    }
}

