/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.client.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.cis.license.client.impl.CacheAssetManagementServiceImpl;
import com.vmware.vim.binding.cis.license.management.AssetManagementService;
import com.vmware.vim.binding.cis.license.management.SystemManagementService;
import com.vmware.vim.binding.cis.license.report.ReportService;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;

public class CacheLicenseClientImpl
implements LicenseClient {
    private LicenseClient _licenseClient;
    private CacheAssetManagementServiceImpl _cacheAssetManagementService;

    public CacheLicenseClientImpl(LicenseClient licenseClient, long invalidationIntervalMs, int cacheCapacity) {
        this._licenseClient = licenseClient;
        this._cacheAssetManagementService = new CacheAssetManagementServiceImpl(this._licenseClient.getAssetManagementService(), invalidationIntervalMs, cacheCapacity);
    }

    @Override
    public AssetManagementService getAssetManagementService() {
        return this._cacheAssetManagementService;
    }

    @Override
    public SystemManagementService getSystemManagementService() {
        return this._licenseClient.getSystemManagementService();
    }

    @Override
    public ReportService getReportService() {
        return this._licenseClient.getReportService();
    }

    @Override
    public <T extends ManagedObject> T getManagedObject(Class<T> typeClass, ManagedObjectReference moRef) {
        return this._licenseClient.getManagedObject(typeClass, moRef);
    }

    @Override
    public void login(SamlToken token, PrivateKey privateKey) {
        this._licenseClient.login(token, privateKey);
    }

    @Override
    public void logout() {
        this._cacheAssetManagementService.invalidateCache();
        this._licenseClient.logout();
    }

    @Override
    public void close() {
        this._cacheAssetManagementService.invalidateCache();
        this._cacheAssetManagementService = null;
        this._licenseClient.close();
    }
}

