/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.client.impl;

import com.vmware.cis.license.client.impl.SiteAffinityServerEndpointProviderException;
import com.vmware.identity.cdc.CdcDCEntry;
import com.vmware.identity.cdc.CdcFactory;
import com.vmware.identity.cdc.CdcSession;
import com.vmware.identity.cdc.CdcState;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SiteAffinityServerEndpointProviderImpl
implements ServerEndpointProvider {
    private final URI _serverUri;
    private static final int FLAGS = 0;
    private static final Log _log = LogFactory.getLog(SiteAffinityServerEndpointProviderImpl.class);

    public SiteAffinityServerEndpointProviderImpl(URI serverUri) {
        this._serverUri = serverUri;
    }

    public URI getServerEndpoint() {
        try {
            URI uri = this.getServiceLocationInternal();
            return uri;
        }
        catch (UnsatisfiedLinkError e) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("CDC not configured %s", e.toString()));
            }
            return this._serverUri;
        }
        catch (NoClassDefFoundError e1) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("CDC not configured %s", e1.toString()));
            }
            return this._serverUri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI getServiceLocationInternal() {
        CdcSession cdcSession = null;
        try {
            boolean isSiteAffinityOn;
            cdcSession = CdcFactory.createCdcSessionViaIPC();
            boolean bl = isSiteAffinityOn = cdcSession.getCdcState() == CdcState.CDC_STATE_SITE_AFFINITIZED;
            if (!isSiteAffinityOn) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Site is not affinitized");
                }
                URI uRI = this._serverUri;
                return uRI;
            }
            URI uRI = this.getDomainController(cdcSession);
            return uRI;
        }
        catch (SiteAffinityServerEndpointProviderException e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)String.format("Failed to create affinitized URL %s", e.toString()));
            }
            throw e;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)String.format("Failed to create affinitized URL %s", e.toString()));
            }
            URI uRI = this._serverUri;
            return uRI;
        }
        finally {
            if (cdcSession != null) {
                cdcSession.close();
            }
        }
    }

    private URI getDomainController(CdcSession cdcSession) {
        try {
            CdcDCEntry domainController = cdcSession.getAffinitizedDC(null, 0);
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("Site affinity DC name: %s", domainController.dcName));
            }
            URI affinitizedUrl = new URI(this._serverUri.getScheme(), this._serverUri.getUserInfo(), domainController.dcName, this._serverUri.getPort(), this._serverUri.getPath(), this._serverUri.getQuery(), this._serverUri.getFragment());
            return affinitizedUrl;
        }
        catch (Exception e) {
            throw new SiteAffinityServerEndpointProviderException("Failed to create affinitized URL", e);
        }
    }
}

