/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.vcops.impl;

import com.vmware.opsmgmt.vcops.VcopsPermissionChecker;
import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcopsPermissionCheckerImpl
implements VcopsPermissionChecker {
    private static final Log _logger = LogFactory.getLog(VcopsPermissionCheckerImpl.class);
    private static final String EXTENSION_PERMISSION = "Extension.Register";
    private static final String[] VCOPS_PRIVILEGES = new String[]{"Extension.Register"};

    @Override
    public boolean getHasVcOpsInstallPermissions(ManagedObjectReference managedObjectReference) {
        VcService vcService = VimSessionUtil.getService((String)managedObjectReference.getServerGuid());
        ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
        try {
            AuthorizationManager authorizationManager = (AuthorizationManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceInstanceContent.authorizationManager);
            String string = vcService.getConnectionInfo().getUserSession().getKey();
            boolean[] blArray = authorizationManager.hasPrivilegeOnEntity(managedObjectReference, string, VCOPS_PRIVILEGES);
            assert (blArray.length == 1);
            return blArray[0];
        }
        catch (Exception exception) {
            _logger.error((Object)("Could not check vCOps security permissions for the object in the VC server with GUID = " + managedObjectReference.getServerGuid()), (Throwable)exception);
            return false;
        }
    }
}

