/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.vcops.impl;

import com.vmware.opsmgmt.client.commons.util.ManagedObjectTypes;
import com.vmware.opsmgmt.vcops.VcopsVappInfoRetriever;
import com.vmware.opsmgmt.vcops.model.VcopsVappConnectionData;
import com.vmware.opsmgmt.vcops.util.VcopsInstallerUtil;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.vApp.ProductInfo;
import com.vmware.vim.binding.vim.vApp.PropertyInfo;
import com.vmware.vim.binding.vim.vApp.VAppConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcopsVappInfoRetriverImpl
implements VcopsVappInfoRetriever {
    private static final Log _logger = LogFactory.getLog(VcopsVappInfoRetriever.class);
    private static final String NAME_PROPERTY = "name";
    private static final String VAPP_CONFIG_PROPERTY = "vAppConfig";
    private static final String POWER_STATE_PROPERTY = "powerState";
    private final DataService _dataService;
    private final VcopsInstallerUtil _vcopsInstallerUtil;

    public VcopsVappInfoRetriverImpl(DataService dataService, VcopsInstallerUtil vcopsInstallerUtil) {
        this._dataService = dataService;
        this._vcopsInstallerUtil = vcopsInstallerUtil;
    }

    @Override
    public VcopsVappConnectionData[] getVcopsVapps() throws Exception {
        Constraint constraint = new Constraint();
        constraint.targetType = ManagedObjectTypes.VAPP.getObjectType();
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{NAME_PROPERTY, VAPP_CONFIG_PROPERTY, POWER_STATE_PROPERTY});
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this._dataService.getData(requestSpec);
        if (response == null) {
            _logger.error((Object)"Error retrieving vcOps Vapps: null response");
            return null;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])response.resultSet)) {
            return null;
        }
        return this.extractVcopsVapps(response.resultSet);
    }

    private VcopsVappConnectionData[] extractVcopsVapps(ResultSet[] resultSetArray) {
        ArrayList<VcopsVappConnectionData> arrayList = new ArrayList<VcopsVappConnectionData>();
        for (ResultSet resultSet : resultSetArray) {
            Object[] objectArray;
            if (resultSet == null || ArrayUtil.isNullOrEmpty((Object[])(objectArray = resultSet.items))) continue;
            VcopsVappConnectionData vcopsVappConnectionData = null;
            List<Object> list = Arrays.asList(objectArray);
            for (ResultItem resultItem : list) {
                String string = (String)this.findPropertyValueIn(NAME_PROPERTY, resultItem);
                VAppConfigInfo vAppConfigInfo = (VAppConfigInfo)this.findPropertyValueIn(VAPP_CONFIG_PROPERTY, resultItem);
                VirtualApp.VAppState vAppState = (VirtualApp.VAppState)this.findPropertyValueIn(POWER_STATE_PROPERTY, resultItem);
                ManagedObjectReference managedObjectReference = null;
                if (resultSet != null && resultItem.resourceObject instanceof ManagedObjectReference) {
                    managedObjectReference = (ManagedObjectReference)resultItem.resourceObject;
                }
                if ((vcopsVappConnectionData = this.buildVcopsVappData(vAppConfigInfo, vAppState, string, managedObjectReference)) == null) continue;
                arrayList.add(vcopsVappConnectionData);
            }
        }
        return arrayList.toArray(new VcopsVappConnectionData[arrayList.size()]);
    }

    private <T> T findPropertyValueIn(String string, ResultItem resultItem) {
        Object[] objectArray = resultItem.properties;
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return null;
        }
        for (Object object : objectArray) {
            if (!((PropertyValue)object).propertyName.equals(string)) continue;
            return (T)((PropertyValue)object).value;
        }
        return null;
    }

    private VcopsVappConnectionData buildVcopsVappData(VAppConfigInfo vAppConfigInfo, VirtualApp.VAppState vAppState, String string, ManagedObjectReference managedObjectReference) {
        if (ArrayUtil.isNullOrEmpty((Object[])vAppConfigInfo.product)) {
            return null;
        }
        String string2 = null;
        for (ProductInfo stringArray2 : vAppConfigInfo.product) {
            if (stringArray2.name == null || !this._vcopsInstallerUtil.hasVcopsName(stringArray2.name)) continue;
            string2 = stringArray2.appUrl;
            break;
        }
        if (StringUtil.isNullOrEmpty(string2)) {
            return null;
        }
        int n = string2.indexOf("{") + 1;
        int n2 = string2.indexOf("}");
        if (n < 0 || n2 < 0) {
            _logger.info((Object)("Incorrect appURL found: " + string2));
            return null;
        }
        String string3 = string2.substring(n, n2);
        String[] stringArray = string3.split("\\.");
        if (stringArray.length != 3) {
            _logger.warn((Object)("Unable to retrieve vcops IP from " + string2 + ".Skip adding of VAPP: " + string));
            return null;
        }
        if (vAppConfigInfo.property == null || vAppConfigInfo.property.length == 0) {
            _logger.warn((Object)("Unable to retrieve vcops IP from " + string2 + ", because there are no properties in the vAppConfig. Skip adding of VAPP: " + string));
            return null;
        }
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        String string6 = stringArray[2];
        String string7 = "";
        for (PropertyInfo propertyInfo : vAppConfigInfo.property) {
            if (!propertyInfo.classId.equals(string4) || !propertyInfo.id.equals(string5) || !propertyInfo.instanceId.equals(string6)) continue;
            string7 = propertyInfo.value;
            break;
        }
        VcopsVappConnectionData vcopsVappConnectionData = new VcopsVappConnectionData();
        vcopsVappConnectionData.vAppName = string;
        if (managedObjectReference != null) {
            vcopsVappConnectionData.serverGuid = managedObjectReference.getServerGuid();
        }
        if (!StringUtil.isNullOrEmpty((String)string7)) {
            string2 = string2.replace("${" + string3 + "}", string7);
            vcopsVappConnectionData.uiVmIp = string7;
            vcopsVappConnectionData.vCopsURL = string2;
            vcopsVappConnectionData.vCopsAdminURL = string2;
            vcopsVappConnectionData.vCopsAdminURL = string2.endsWith("/") ? vcopsVappConnectionData.vCopsAdminURL + "admin" : vcopsVappConnectionData.vCopsAdminURL + "/admin";
        }
        if (vAppState.equals((Object)VirtualApp.VAppState.started) || vAppState.equals((Object)VirtualApp.VAppState.starting)) {
            vcopsVappConnectionData.isVappPoweredOn = true;
        }
        return vcopsVappConnectionData;
    }
}

