/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.auth.internal;

import com.vmware.vise.search.auth.AuthData;
import com.vmware.vise.search.auth.AuthDataProvider;
import com.vmware.vise.search.auth.internal.AuthDataRegistryEvent;
import com.vmware.vise.search.auth.internal.AuthDataRegistryInternal;
import com.vmware.vise.search.auth.internal.AuthDataRegistryListener;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthDataRegistryImpl
implements AuthDataRegistryInternal {
    private static final Log _logger = LogFactory.getLog(AuthDataRegistryImpl.class);
    private final ConcurrentMap<String, RegistryElement> _authDataMap = new ConcurrentHashMap<String, RegistryElement>();
    private final List<AuthDataRegistryListener> _listeners = new ArrayList<AuthDataRegistryListener>();

    private void validateServiceEndpointUrl(String string) {
        if (StringUtil.isNullOrWhitespace((String)string)) {
            throw new IllegalArgumentException("The serviceEndpointUrl shouldn't be null or whitespace");
        }
    }

    @Override
    public void add(String string, AuthDataProvider authDataProvider) {
        this.validateServiceEndpointUrl(string);
        if (authDataProvider == null) {
            throw new IllegalArgumentException("The authDataProvider shouldn't be null");
        }
        RegistryElement registryElement = new RegistryElement(authDataProvider);
        this._authDataMap.put(string, registryElement);
        this.notifyListeners(string, registryElement, EventType.ADD);
    }

    @Override
    public AuthData get(String string) {
        this.validateServiceEndpointUrl(string);
        RegistryElement registryElement = (RegistryElement)this._authDataMap.get(string);
        if (registryElement == null) {
            return null;
        }
        AuthData authData = registryElement.getAuthData();
        if (authData != null) {
            return authData;
        }
        AuthDataProvider authDataProvider = registryElement.getAuthDataProvider();
        authData = authDataProvider.getAuthData(string);
        return authData;
    }

    @Override
    public boolean remove(String string) {
        this.validateServiceEndpointUrl(string);
        RegistryElement registryElement = (RegistryElement)this._authDataMap.remove(string);
        if (registryElement != null) {
            this.notifyListeners(string, registryElement, EventType.REMOVE);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(String string, AuthDataProvider authDataProvider) {
        this.validateServiceEndpointUrl(string);
        if (authDataProvider == null) {
            throw new IllegalArgumentException("The expectedValue shouldn't be null");
        }
        RegistryElement registryElement = new RegistryElement(authDataProvider);
        boolean bl = this._authDataMap.remove(string, registryElement);
        if (bl) {
            this.notifyListeners(string, registryElement, EventType.REMOVE);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(AuthDataRegistryListener authDataRegistryListener) {
        if (authDataRegistryListener == null) {
            throw new IllegalArgumentException("The listener shouldn't be null");
        }
        List<AuthDataRegistryListener> list = this._listeners;
        synchronized (list) {
            this._listeners.add(authDataRegistryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(AuthDataRegistryListener authDataRegistryListener) {
        if (authDataRegistryListener == null) {
            throw new IllegalArgumentException("The listener shouldn't be null");
        }
        List<AuthDataRegistryListener> list = this._listeners;
        synchronized (list) {
            this._listeners.remove(authDataRegistryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AuthDataRegistryListener> copyListeners() {
        List<AuthDataRegistryListener> list;
        List<AuthDataRegistryListener> list2 = this._listeners;
        synchronized (list2) {
            list = this._listeners.isEmpty() ? Collections.emptyList() : new ArrayList<AuthDataRegistryListener>(this._listeners);
        }
        return list;
    }

    private void notifyListeners(String string, RegistryElement registryElement, EventType eventType) {
        List<AuthDataRegistryListener> list = this.copyListeners();
        AuthDataRegistryEvent authDataRegistryEvent = new AuthDataRegistryEvent(this, string, registryElement);
        for (AuthDataRegistryListener authDataRegistryListener : list) {
            try {
                switch (eventType) {
                    case ADD: {
                        authDataRegistryListener.authDataAdded(authDataRegistryEvent);
                        break;
                    }
                    case REMOVE: {
                        authDataRegistryListener.authDataRemoved(authDataRegistryEvent);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported event type: " + (Object)((Object)eventType));
                    }
                }
            }
            catch (Exception exception) {
                _logger.error((Object)(AuthDataRegistryListener.class.getSimpleName() + " invocation failed"), (Throwable)exception);
            }
        }
    }

    static class RegistryElement {
        private final AuthData _authData;
        private final AuthDataProvider _authDataProvider;
        private volatile int _cachedHashCode;

        private RegistryElement(AuthData authData) {
            if (authData == null) {
                throw new IllegalArgumentException("The " + AuthData.class.getSimpleName() + " shouldn't be null");
            }
            this._authData = authData;
            this._authDataProvider = null;
        }

        public RegistryElement(AuthDataProvider authDataProvider) {
            if (authDataProvider == null) {
                throw new IllegalArgumentException("The " + AuthDataProvider.class.getSimpleName() + " shouldn't be null");
            }
            this._authDataProvider = authDataProvider;
            this._authData = null;
        }

        public AuthData getAuthData() {
            return this._authData;
        }

        public AuthDataProvider getAuthDataProvider() {
            return this._authDataProvider;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (RegistryElement.class.equals(object.getClass())) {
                RegistryElement registryElement = (RegistryElement)object;
                boolean bl = (this._authData == null ? registryElement._authData == null : this._authData.equals(registryElement._authData)) && (this._authDataProvider == null ? registryElement._authDataProvider == null : this._authDataProvider.equals(registryElement._authDataProvider));
                return bl;
            }
            return false;
        }

        public int hashCode() {
            int n = this._cachedHashCode;
            if (n == 0) {
                n = 17;
                n = 31 * n + (this._authData != null ? this._authData.hashCode() : 0);
                this._cachedHashCode = n = 31 * n + (this._authDataProvider != null ? this._authDataProvider.hashCode() : 0);
            }
            return n;
        }
    }

    private static enum EventType {
        ADD,
        REMOVE;

    }
}

