/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.ConstraintConjoiner;
import com.vmware.vise.search.impl.CompositeConstraintInternal;
import com.vmware.vise.search.impl.ConstraintBase;
import com.vmware.vise.search.impl.ConstraintInternal;
import com.vmware.vise.search.impl.ConstraintVisitor;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;

final class CompositeConstraintImpl
extends ConstraintBase
implements CompositeConstraintInternal {
    private final List<ConstraintInternal> _nestedConstraints = new ArrayList<ConstraintInternal>();
    private ConstraintConjoiner _conjoiner;

    CompositeConstraintImpl() {
    }

    @Override
    public ConstraintInternal[] getNestedConstraints() {
        ConstraintInternal[] constraintInternalArray = this._nestedConstraints.toArray(new ConstraintInternal[this._nestedConstraints.size()]);
        return constraintInternalArray;
    }

    @Override
    public void setNestedConstraints(Constraint[] constraintArray) {
        this._nestedConstraints.clear();
        if (constraintArray != null) {
            for (Constraint constraint : constraintArray) {
                if (!(constraint instanceof ConstraintInternal)) continue;
                ConstraintInternal constraintInternal = (ConstraintInternal)constraint;
                constraintInternal.setParentConstraint(this);
                this._nestedConstraints.add(constraintInternal);
            }
        }
    }

    @Override
    public ConstraintConjoiner getConjoiner() {
        return this._conjoiner;
    }

    @Override
    public void setConjoiner(ConstraintConjoiner constraintConjoiner) {
        this._conjoiner = constraintConjoiner;
    }

    @Override
    public void add(Constraint constraint) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{constraint});
        if (constraint instanceof ConstraintInternal) {
            ConstraintInternal constraintInternal = (ConstraintInternal)constraint;
            constraintInternal.setParentConstraint(this);
            this._nestedConstraints.add(constraintInternal);
        }
    }

    @Override
    public void set(int n, Constraint constraint) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{constraint});
        if (constraint instanceof ConstraintInternal) {
            ConstraintInternal constraintInternal = (ConstraintInternal)constraint;
            constraintInternal.setParentConstraint(this);
            this._nestedConstraints.set(n, constraintInternal);
        }
    }

    @Override
    public void remove(Constraint constraint) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{constraint});
        if (constraint instanceof ConstraintInternal && ((ConstraintInternal)constraint).getParentConstraint() == this) {
            ((ConstraintInternal)constraint).setParentConstraint(null);
        }
        this._nestedConstraints.remove(constraint);
    }

    @Override
    public ConstraintInternal[] getChildren() {
        return this.getNestedConstraints();
    }

    @Override
    public void addChild(ConstraintInternal constraintInternal) {
        this.add(constraintInternal);
    }

    @Override
    public void setChild(int n, ConstraintInternal constraintInternal) {
        this.set(n, constraintInternal);
    }

    @Override
    public void removeChild(ConstraintInternal constraintInternal) {
        this.remove(constraintInternal);
    }

    @Override
    public void clearChildren() {
        this._nestedConstraints.clear();
    }

    @Override
    public void accept(ConstraintVisitor constraintVisitor) {
        constraintVisitor.visitCompositeConstraint(this);
    }

    @Override
    public int getNumberOfNestedConstraints() {
        int n;
        int n2 = n = this._nestedConstraints.size();
        for (int i = 0; i < n; ++i) {
            ConstraintInternal constraintInternal = this._nestedConstraints.get(i);
            if (constraintInternal == null) continue;
            n2 += constraintInternal.getNumberOfNestedConstraints();
        }
        return n2;
    }

    @Override
    public CompositeConstraintImpl getDeepCopy() {
        CompositeConstraintImpl compositeConstraintImpl = new CompositeConstraintImpl();
        compositeConstraintImpl.copyFields(this);
        compositeConstraintImpl._conjoiner = this._conjoiner;
        for (ConstraintInternal constraintInternal : this._nestedConstraints) {
            if (constraintInternal == null) {
                compositeConstraintImpl._nestedConstraints.add(null);
                continue;
            }
            ConstraintInternal constraintInternal2 = (ConstraintInternal)constraintInternal.getDeepCopy();
            constraintInternal2.setParentConstraint(compositeConstraintImpl);
            compositeConstraintImpl._nestedConstraints.add(constraintInternal2);
        }
        return compositeConstraintImpl;
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n, int n2) {
        super.toString(stringBuilder, n, n2);
        stringBuilder.append("\n");
        StringUtil.appendPadding((StringBuilder)stringBuilder, (int)(++n * n2), (String)" ");
        stringBuilder.append("ConstraintConjoiner: ").append((Object)this.getConjoiner());
        for (ConstraintInternal constraintInternal : this._nestedConstraints) {
            if (constraintInternal == null) continue;
            stringBuilder.append("\n");
            constraintInternal.toString(stringBuilder, n, n2);
        }
    }
}

