/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.CompositeConstraint;
import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.ConstraintConjoiner;
import com.vmware.vise.search.impl.CompositeConstraintImpl;
import com.vmware.vise.search.impl.ConstraintInternal;

final class ConstraintUtils {
    ConstraintUtils() {
    }

    static String getSearchTargetType(ConstraintInternal constraintInternal) {
        return constraintInternal.getSearchTarget();
    }

    static boolean areConjoinedTwins(ConstraintInternal constraintInternal, ConstraintInternal constraintInternal2) {
        return constraintInternal != constraintInternal2 && constraintInternal.getParentConstraint() != null && constraintInternal.getParentConstraint() == constraintInternal2.getParentConstraint();
    }

    public static Constraint combineIntoSingleConstraint(Constraint[] constraintArray, ConstraintConjoiner constraintConjoiner) {
        if (constraintArray == null || constraintArray.length == 0) {
            return null;
        }
        if (constraintArray.length == 1) {
            return constraintArray[0];
        }
        CompositeConstraint compositeConstraint = ConstraintUtils.createCompositeConstraint(constraintArray, constraintConjoiner);
        return compositeConstraint;
    }

    public static CompositeConstraint createCompositeConstraint(Constraint[] constraintArray, ConstraintConjoiner constraintConjoiner) {
        CompositeConstraintImpl compositeConstraintImpl = new CompositeConstraintImpl();
        compositeConstraintImpl.setNestedConstraints(constraintArray);
        compositeConstraintImpl.setConjoiner(constraintConjoiner);
        return compositeConstraintImpl;
    }
}

