/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.impl.CompositeConstraintInternal;
import com.vmware.vise.search.impl.ConstraintInternal;
import com.vmware.vise.search.impl.ConstraintVisitorBase;
import com.vmware.vise.search.impl.EntitySetDescriptor;
import com.vmware.vise.search.impl.ObjectIdentityConstraintInternal;
import com.vmware.vise.search.impl.PredicateExpr;
import com.vmware.vise.search.impl.PredicatedSetExpr;
import com.vmware.vise.search.impl.QueryElement;
import com.vmware.vise.search.impl.QueryExpr;
import com.vmware.vise.search.impl.RelationalConstraintInternal;
import com.vmware.vise.search.impl.SetExpr;
import com.vmware.vise.search.impl.SimplePropertyConstraintInternal;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.metadata.MetadataDirectory;
import java.util.Map;

public class ExpressionTreeApplyOptimizationVisitor
extends ConstraintVisitorBase {
    private final Map<ConstraintInternal, ConstraintVisitorBase.SimplificationType> _simplTypeByConstraint;
    private final MetadataDirectory _metadataDirectory;
    private final TypeRefDirectory _typeRefDirectory;

    public ExpressionTreeApplyOptimizationVisitor(MetadataDirectory metadataDirectory, TypeRefDirectory typeRefDirectory, Map<ConstraintInternal, ConstraintVisitorBase.SimplificationType> map, Map<ConstraintInternal, ConstraintVisitorBase.VisitContext> map2) {
        super(map2);
        this._metadataDirectory = metadataDirectory;
        this._typeRefDirectory = typeRefDirectory;
        this._simplTypeByConstraint = map;
    }

    @Override
    public void visitDefaultConstraint(ConstraintInternal constraintInternal) {
        this.tryTurnIntoPredicateExpr(constraintInternal);
    }

    @Override
    public void visitSimplePropertyConstraint(SimplePropertyConstraintInternal simplePropertyConstraintInternal) {
        this.tryTurnIntoPredicateExpr(simplePropertyConstraintInternal);
    }

    @Override
    public void visitObjectIdentityConstraint(ObjectIdentityConstraintInternal objectIdentityConstraintInternal) {
        this.tryTurnIntoPredicateExpr(objectIdentityConstraintInternal);
    }

    @Override
    public void visitRelationalConstraint(RelationalConstraintInternal relationalConstraintInternal) {
    }

    @Override
    public void visitCompositeConstraint(CompositeConstraintInternal compositeConstraintInternal) {
        ConstraintVisitorBase.SimplificationType simplificationType = this._simplTypeByConstraint.get(compositeConstraintInternal);
        switch (simplificationType) {
            case PredicateExpr: {
                this.turnIntoPredicateExpr(compositeConstraintInternal);
                break;
            }
            case PredicateSetExpr: 
            case ObjectSetExpr: {
                this.turnIntoPredicatedSetExpr(compositeConstraintInternal);
                break;
            }
        }
    }

    private void tryTurnIntoPredicateExpr(ConstraintInternal constraintInternal) {
        if (this._simplTypeByConstraint.get(constraintInternal) == ConstraintVisitorBase.SimplificationType.PredicateExpr) {
            this.turnIntoPredicateExpr(constraintInternal);
        }
    }

    private void turnIntoPredicateExpr(ConstraintInternal constraintInternal) {
        this._simplTypeByConstraint.put(constraintInternal, ConstraintVisitorBase.SimplificationType.PredicateExpr);
        ConstraintVisitorBase.VisitContext visitContext = this.getVisitContext(constraintInternal);
        if (visitContext != null) {
            PredicateExpr predicateExpr = this.toPredicateExpr(visitContext.context.conditional);
            this.substituteOld(visitContext, predicateExpr);
        }
    }

    private void turnIntoPredicatedSetExpr(CompositeConstraintInternal compositeConstraintInternal) {
        ConstraintVisitorBase.VisitContext visitContext = this.getVisitContext(compositeConstraintInternal);
        if (visitContext != null) {
            PredicatedSetExpr predicatedSetExpr = this.toPredicatedSetExpr(visitContext.context.conditional);
            this.substituteOld(visitContext, predicatedSetExpr);
        }
    }

    private void substituteOld(ConstraintVisitorBase.VisitContext visitContext, QueryExpr queryExpr) {
        QueryExpr queryExpr2 = visitContext.context.conditional;
        QueryElement queryElement = queryExpr2.getParent();
        if (queryElement != null) {
            if (queryElement instanceof SetExpr) {
                ((SetExpr)queryElement).replaceChild(queryExpr2, queryExpr);
            } else if (queryElement instanceof EntitySetDescriptor && queryExpr instanceof SetExpr) {
                ((EntitySetDescriptor)queryElement).setSetExpr((SetExpr)queryExpr);
            }
        }
        for (QueryExpr queryExpr3 : (QueryExpr[])queryExpr2.getChildren()) {
            queryExpr.addChild(queryExpr3);
        }
        visitContext.context.conditional = queryExpr;
    }

    private void copyConditional(QueryExpr queryExpr, QueryExpr queryExpr2) {
        queryExpr.setEntityType(queryExpr2.getEntityType());
        queryExpr.setConjoiner(queryExpr2.getConjoiner());
        if (queryExpr instanceof SetExpr && queryExpr2 instanceof SetExpr) {
            ((SetExpr)queryExpr).exprDefinesDocSet = ((SetExpr)queryExpr2).exprDefinesDocSet;
        }
        queryExpr.setExpr(queryExpr2.getExpr());
    }

    private PredicateExpr toPredicateExpr(QueryExpr queryExpr) {
        PredicateExpr predicateExpr = new PredicateExpr();
        this.copyConditional(predicateExpr, queryExpr);
        return predicateExpr;
    }

    private PredicatedSetExpr toPredicatedSetExpr(QueryExpr queryExpr) {
        PredicatedSetExpr predicatedSetExpr = new PredicatedSetExpr(this._metadataDirectory, this._typeRefDirectory);
        this.copyConditional(predicatedSetExpr, queryExpr);
        return predicatedSetExpr;
    }
}

